/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.tree;

import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMap;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.mapping.tree.HashTreeNode;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class HashEntryTree<T>
implements EntryTree<T> {
    private final Map<Entry<?>, HashTreeNode<T>> root = new HashMap();

    public HashEntryTree() {
    }

    public HashEntryTree(EntryTree<T> tree) {
        for (EntryTreeNode<T> node : tree.getAllNodes()) {
            this.insert(node.getEntry(), node.getValue());
        }
    }

    @Override
    public void insert(Entry<?> entry, T value) {
        List<HashTreeNode<T>> path = this.computePath(entry);
        path.get(path.size() - 1).putValue(value);
        if (value == null) {
            this.removeDeadAlong(path);
        }
    }

    @Override
    @Nullable
    public T remove(Entry<?> entry) {
        List<HashTreeNode<T>> path = this.computePath(entry);
        T value = path.get(path.size() - 1).removeValue();
        this.removeDeadAlong(path);
        return value;
    }

    @Override
    @Nullable
    public T get(Entry<?> entry) {
        EntryTreeNode node = this.findNode((Entry)entry);
        if (node == null) {
            return null;
        }
        return ((HashTreeNode)node).getValue();
    }

    @Override
    public boolean contains(Entry<?> entry) {
        return this.get(entry) != null;
    }

    @Override
    public Collection<Entry<?>> getChildren(Entry<?> entry) {
        EntryTreeNode leaf = this.findNode((Entry)entry);
        if (leaf == null) {
            return Collections.emptyList();
        }
        return ((HashTreeNode)leaf).getChildren();
    }

    @Override
    public Collection<Entry<?>> getSiblings(Entry<?> entry) {
        List<HashTreeNode<T>> path = this.computePath(entry);
        if (path.size() <= 1) {
            return this.getSiblings(entry, this.root.keySet());
        }
        HashTreeNode<T> parent = path.get(path.size() - 2);
        return this.getSiblings(entry, parent.getChildren());
    }

    private Collection<Entry<?>> getSiblings(Entry<?> entry, Collection<Entry<?>> children) {
        HashSet siblings = new HashSet(children);
        siblings.remove(entry);
        return siblings;
    }

    @Override
    @Nullable
    public HashTreeNode<T> findNode(Entry<?> target) {
        List<Entry<?>> parentChain = target.getAncestry();
        if (parentChain.isEmpty()) {
            return null;
        }
        HashTreeNode<T> node = this.root.get(parentChain.get(0));
        for (int i = 1; i < parentChain.size(); ++i) {
            if (node == null) {
                return null;
            }
            node = node.getChild(parentChain.get(i), false);
        }
        return node;
    }

    private List<HashTreeNode<T>> computePath(Entry<?> target) {
        List<Entry<?>> ancestry = target.getAncestry();
        if (ancestry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HashTreeNode<T>> path = new ArrayList<HashTreeNode<T>>(ancestry.size());
        Entry<?> rootEntry = ancestry.get(0);
        HashTreeNode node = this.root.computeIfAbsent(rootEntry, HashTreeNode::new);
        path.add(node);
        for (int i = 1; i < ancestry.size(); ++i) {
            node = node.getChild(ancestry.get(i), true);
            path.add(node);
        }
        return path;
    }

    private void removeDeadAlong(List<HashTreeNode<T>> path) {
        HashTreeNode<T> node;
        for (int i = path.size() - 1; i >= 0 && (node = path.get(i)).isEmpty(); --i) {
            if (i > 0) {
                HashTreeNode<T> parentNode = path.get(i - 1);
                parentNode.remove(node.getEntry());
                continue;
            }
            this.root.remove(node.getEntry());
        }
    }

    @Override
    public Iterator<EntryTreeNode<T>> iterator() {
        Collection<HashTreeNode<T>> values = this.root.values();
        return values.iterator();
    }

    @Override
    public Collection<EntryTreeNode<T>> getAllNodes() {
        ArrayList<EntryTreeNode<T>> nodes = new ArrayList<EntryTreeNode<T>>();
        for (EntryTreeNode entryTreeNode : this.root.values()) {
            nodes.addAll(entryTreeNode.getNodesRecursively());
        }
        return nodes;
    }

    @Override
    public Collection<Entry<?>> getAllEntries() {
        return this.getAllNodes().stream().map(EntryTreeNode::getEntry).collect(Collectors.toList());
    }

    @Override
    public Collection<Entry<?>> getRootEntries() {
        return this.root.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    @Override
    public HashEntryTree<T> translate(Translator translator, EntryResolver resolver, EntryMap<EntryMapping> mappings) {
        HashEntryTree<T> translatedTree = new HashEntryTree<T>();
        for (EntryTreeNode<T> node : this.getAllNodes()) {
            translatedTree.insert(translator.translate(node.getEntry()), node.getValue());
        }
        return translatedTree;
    }
}

