/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import cuchaz.enigma.utils.Utils;
import javax.annotation.Nullable;

public class FieldEntry
extends ParentedEntry<ClassEntry>
implements Comparable<FieldEntry> {
    protected final TypeDescriptor desc;

    public FieldEntry(ClassEntry parent, String name, TypeDescriptor desc) {
        super(parent, name);
        Preconditions.checkNotNull((Object)parent, (Object)"Owner cannot be null");
        Preconditions.checkNotNull((Object)desc, (Object)"Field descriptor cannot be null");
        this.desc = desc;
    }

    public static FieldEntry parse(String owner, String name, String desc) {
        return new FieldEntry(new ClassEntry(owner), name, new TypeDescriptor(desc));
    }

    @Override
    public Class<ClassEntry> getParentType() {
        return ClassEntry.class;
    }

    public TypeDescriptor getDesc() {
        return this.desc;
    }

    public FieldEntry withParent(ClassEntry parent) {
        return new FieldEntry(parent, this.name, this.desc);
    }

    protected FieldEntry translate(Translator translator, @Nullable EntryMapping mapping) {
        String translatedName = mapping != null ? mapping.getTargetName() : this.name;
        return new FieldEntry((ClassEntry)this.parent, translatedName, translator.translate(this.desc));
    }

    public int hashCode() {
        return Utils.combineHashesOrdered(this.parent, this.name, this.desc);
    }

    public boolean equals(Object other) {
        return other instanceof FieldEntry && this.equals((FieldEntry)other);
    }

    public boolean equals(FieldEntry other) {
        return ((ClassEntry)this.parent).equals((ClassEntry)other.parent) && this.name.equals(other.name) && this.desc.equals(other.desc);
    }

    @Override
    public boolean canConflictWith(Entry<?> entry) {
        return entry instanceof FieldEntry && ((ClassEntry)((FieldEntry)entry).parent).equals((ClassEntry)this.parent);
    }

    public String toString() {
        return ((ClassEntry)this.parent).getFullName() + "." + this.name + ":" + this.desc;
    }

    @Override
    public int compareTo(FieldEntry entry) {
        return (this.name + this.desc.toString()).compareTo(entry.name + entry.desc.toString());
    }
}

