/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import javax.annotation.Nullable;

public class LocalVariableDefEntry
extends LocalVariableEntry {
    protected final TypeDescriptor desc;

    public LocalVariableDefEntry(MethodEntry ownerEntry, int index, String name, boolean parameter, TypeDescriptor desc) {
        super(ownerEntry, index, name, parameter);
        Preconditions.checkNotNull((Object)desc, (Object)"Variable desc cannot be null");
        this.desc = desc;
    }

    public TypeDescriptor getDesc() {
        return this.desc;
    }

    @Override
    public LocalVariableDefEntry translate(Translator translator, @Nullable EntryMapping mapping) {
        TypeDescriptor translatedDesc = translator.translate(this.desc);
        String translatedName = mapping != null ? mapping.getTargetName() : this.name;
        return new LocalVariableDefEntry((MethodEntry)this.parent, this.index, translatedName, this.parameter, translatedDesc);
    }

    @Override
    public LocalVariableDefEntry withParent(MethodEntry entry) {
        return new LocalVariableDefEntry(entry, this.index, this.name, this.parameter, this.desc);
    }

    @Override
    public String toString() {
        return this.parent + "(" + this.index + ":" + this.name + ":" + this.desc + ")";
    }
}

