/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import cuchaz.enigma.utils.Utils;
import javax.annotation.Nullable;

public class MethodEntry
extends ParentedEntry<ClassEntry>
implements Comparable<MethodEntry> {
    protected final MethodDescriptor descriptor;

    public MethodEntry(ClassEntry parent, String name, MethodDescriptor descriptor) {
        super(parent, name);
        Preconditions.checkNotNull((Object)parent, (Object)"Parent cannot be null");
        Preconditions.checkNotNull((Object)descriptor, (Object)"Method descriptor cannot be null");
        this.descriptor = descriptor;
    }

    public static MethodEntry parse(String owner, String name, String desc) {
        return new MethodEntry(new ClassEntry(owner), name, new MethodDescriptor(desc));
    }

    @Override
    public Class<ClassEntry> getParentType() {
        return ClassEntry.class;
    }

    public MethodDescriptor getDesc() {
        return this.descriptor;
    }

    public boolean isConstructor() {
        return this.name.equals("<init>") || this.name.equals("<clinit>");
    }

    public MethodEntry translate(Translator translator, @Nullable EntryMapping mapping) {
        String translatedName = mapping != null ? mapping.getTargetName() : this.name;
        return new MethodEntry((ClassEntry)this.parent, translatedName, translator.translate(this.descriptor));
    }

    public MethodEntry withParent(ClassEntry parent) {
        return new MethodEntry(new ClassEntry(parent.getFullName()), this.name, this.descriptor);
    }

    public int hashCode() {
        return Utils.combineHashesOrdered(this.parent, this.name, this.descriptor);
    }

    public boolean equals(Object other) {
        return other instanceof MethodEntry && this.equals((MethodEntry)other);
    }

    public boolean equals(MethodEntry other) {
        return ((ClassEntry)this.parent).equals((ClassEntry)other.getParent()) && this.name.equals(other.getName()) && this.descriptor.equals(other.getDesc());
    }

    @Override
    public boolean canConflictWith(Entry<?> entry) {
        if (entry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)entry;
            return ((ClassEntry)methodEntry.parent).equals((ClassEntry)this.parent) && methodEntry.descriptor.canConflictWith(this.descriptor);
        }
        return false;
    }

    public String toString() {
        return ((ClassEntry)this.parent).getFullName() + "." + this.name + this.descriptor;
    }

    @Override
    public int compareTo(MethodEntry entry) {
        return (this.name + this.descriptor.toString()).compareTo(entry.name + entry.descriptor.toString());
    }
}

