/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.EnigmaServices;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.ClassCache;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.api.EnigmaPlugin;
import cuchaz.enigma.api.EnigmaPluginContext;
import cuchaz.enigma.api.service.EnigmaService;
import cuchaz.enigma.api.service.EnigmaServiceFactory;
import cuchaz.enigma.api.service.EnigmaServiceType;
import cuchaz.enigma.api.service.JarIndexerService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ServiceLoader;

public class Enigma {
    private final EnigmaProfile profile;
    private final EnigmaServices services;

    private Enigma(EnigmaProfile profile, EnigmaServices services) {
        this.profile = profile;
        this.services = services;
    }

    public static Enigma create() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public EnigmaProject openJar(Path path, ProgressListener progress) throws IOException {
        ClassCache classCache = ClassCache.of(path);
        JarIndex jarIndex = classCache.index(progress);
        this.services.get(JarIndexerService.TYPE).ifPresent(indexer -> indexer.acceptJar(classCache, jarIndex));
        return new EnigmaProject(this, classCache, jarIndex);
    }

    public EnigmaProfile getProfile() {
        return this.profile;
    }

    public EnigmaServices getServices() {
        return this.services;
    }

    private static class PluginContext
    implements EnigmaPluginContext {
        private final EnigmaProfile profile;
        private final ImmutableMap.Builder<EnigmaServiceType<?>, EnigmaService> services = ImmutableMap.builder();

        PluginContext(EnigmaProfile profile) {
            this.profile = profile;
        }

        @Override
        public <T extends EnigmaService> void registerService(String id, EnigmaServiceType<T> serviceType, EnigmaServiceFactory<T> factory) {
            EnigmaProfile.Service serviceProfile = this.profile.getServiceProfile(serviceType);
            if (serviceProfile == null || !serviceProfile.matches(id)) {
                return;
            }
            T service = factory.create(serviceProfile::getArgument);
            this.services.put(serviceType, (EnigmaService)service);
        }

        EnigmaServices buildServices() {
            return new EnigmaServices(this.services.build());
        }
    }

    public static class Builder {
        private EnigmaProfile profile = EnigmaProfile.EMPTY;
        private Iterable<EnigmaPlugin> plugins = ServiceLoader.load(EnigmaPlugin.class);

        private Builder() {
        }

        public Builder setProfile(EnigmaProfile profile) {
            Preconditions.checkNotNull(profile, "profile cannot be null");
            this.profile = profile;
            return this;
        }

        public Builder setPlugins(Iterable<EnigmaPlugin> plugins) {
            Preconditions.checkNotNull(plugins, "plugins cannot be null");
            this.plugins = plugins;
            return this;
        }

        public Enigma build() {
            PluginContext pluginContext = new PluginContext(this.profile);
            for (EnigmaPlugin plugin : this.plugins) {
                plugin.init(pluginContext);
            }
            EnigmaServices services = pluginContext.buildServices();
            return new Enigma(this.profile, services);
        }
    }
}

