/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import cuchaz.enigma.api.service.EnigmaServiceType;
import cuchaz.enigma.translation.mapping.MappingFileNameFormat;
import cuchaz.enigma.translation.mapping.MappingSaveParameters;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public final class EnigmaProfile {
    public static final EnigmaProfile EMPTY = new EnigmaProfile(ImmutableMap.of());
    private static final MappingSaveParameters DEFAULT_MAPPING_SAVE_PARAMETERS = new MappingSaveParameters(MappingFileNameFormat.BY_DEOBF);
    private static final Gson GSON = new Gson();
    @SerializedName(value="services")
    private final Map<String, Service> serviceProfiles;
    @SerializedName(value="mapping_save_parameters")
    private final MappingSaveParameters mappingSaveParameters = null;

    private EnigmaProfile(Map<String, Service> serviceProfiles) {
        this.serviceProfiles = serviceProfiles;
    }

    public static EnigmaProfile parse(Reader reader) {
        return GSON.fromJson(reader, EnigmaProfile.class);
    }

    @Nullable
    public Service getServiceProfile(EnigmaServiceType<?> serviceType) {
        return this.serviceProfiles.get(serviceType.key);
    }

    public MappingSaveParameters getMappingSaveParameters() {
        return this.mappingSaveParameters == null ? DEFAULT_MAPPING_SAVE_PARAMETERS : this.mappingSaveParameters;
    }

    public static class Service {
        private final String id;
        private final Map<String, String> args;

        Service(String id, Map<String, String> args) {
            this.id = id;
            this.args = args;
        }

        public boolean matches(String id) {
            return this.id.equals(id);
        }

        public Optional<String> getArgument(String key) {
            return this.args != null ? Optional.ofNullable(this.args.get(key)) : Optional.empty();
        }
    }
}

