/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import cuchaz.enigma.CompiledSource;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.bytecode.translators.LocalVariableFixVisitor;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public final class ClassCache
implements AutoCloseable,
CompiledSource {
    private final FileSystem fileSystem;
    private final ImmutableSet<String> classNames;
    private final Cache<String, ClassNode> nodeCache = CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(1L, TimeUnit.MINUTES).build();

    private ClassCache(FileSystem fileSystem, ImmutableSet<String> classNames) {
        this.fileSystem = fileSystem;
        this.classNames = classNames;
    }

    public static ClassCache of(Path jarPath) throws IOException {
        FileSystem fileSystem = FileSystems.newFileSystem(jarPath, null);
        ImmutableSet<String> classNames = ClassCache.collectClassNames(fileSystem);
        return new ClassCache(fileSystem, classNames);
    }

    private static ImmutableSet<String> collectClassNames(FileSystem fileSystem) throws IOException {
        ImmutableSet.Builder classNames = ImmutableSet.builder();
        for (Path root : fileSystem.getRootDirectories()) {
            Files.walk(root, new FileVisitOption[0]).map(Path::toString).forEach(path -> {
                if (path.endsWith(".class")) {
                    String name = path.substring(1, path.length() - ".class".length());
                    classNames.add(name);
                }
            });
        }
        return classNames.build();
    }

    @Override
    @Nullable
    public ClassNode getClassNode(String name) {
        if (!this.classNames.contains(name)) {
            return null;
        }
        try {
            return this.nodeCache.get(name, () -> this.parseNode(name));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private ClassNode parseNode(String name) throws IOException {
        ClassReader reader = this.getReader(name);
        ClassNode node = new ClassNode();
        LocalVariableFixVisitor visitor = new LocalVariableFixVisitor(327680, node);
        reader.accept(visitor, 0);
        return node;
    }

    private ClassReader getReader(String name) throws IOException {
        Path path = this.fileSystem.getPath(name + ".class", new String[0]);
        byte[] bytes = Files.readAllBytes(path);
        return new ClassReader(bytes);
    }

    public int getClassCount() {
        return this.classNames.size();
    }

    public void visit(Supplier<ClassVisitor> visitorSupplier, int readFlags) {
        for (String className : this.classNames) {
            ClassVisitor visitor = visitorSupplier.get();
            ClassNode cached = this.nodeCache.getIfPresent(className);
            if (cached != null) {
                cached.accept(visitor);
                continue;
            }
            try {
                ClassReader reader = this.getReader(className);
                reader.accept(visitor, readFlags);
            }
            catch (IOException e) {
                System.out.println("Failed to visit class " + className);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.fileSystem.close();
    }

    public JarIndex index(ProgressListener progress) {
        JarIndex index = JarIndex.empty();
        index.indexJar(this, progress);
        return index;
    }
}

