/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class EntryIndex
implements JarIndexer {
    private Map<ClassEntry, AccessFlags> classes = new HashMap<ClassEntry, AccessFlags>();
    private Map<FieldEntry, AccessFlags> fields = new HashMap<FieldEntry, AccessFlags>();
    private Map<MethodEntry, AccessFlags> methods = new HashMap<MethodEntry, AccessFlags>();

    @Override
    public void indexClass(ClassDefEntry classEntry) {
        this.classes.put(classEntry, classEntry.getAccess());
    }

    @Override
    public void indexMethod(MethodDefEntry methodEntry) {
        this.methods.put(methodEntry, methodEntry.getAccess());
    }

    @Override
    public void indexField(FieldDefEntry fieldEntry) {
        this.fields.put(fieldEntry, fieldEntry.getAccess());
    }

    public boolean hasClass(ClassEntry entry) {
        return this.classes.containsKey(entry);
    }

    public boolean hasMethod(MethodEntry entry) {
        return this.methods.containsKey(entry);
    }

    public boolean hasField(FieldEntry entry) {
        return this.fields.containsKey(entry);
    }

    public boolean hasEntry(Entry<?> entry) {
        if (entry instanceof ClassEntry) {
            return this.hasClass((ClassEntry)entry);
        }
        if (entry instanceof MethodEntry) {
            return this.hasMethod((MethodEntry)entry);
        }
        if (entry instanceof FieldEntry) {
            return this.hasField((FieldEntry)entry);
        }
        if (entry instanceof LocalVariableEntry) {
            return this.hasMethod((MethodEntry)((LocalVariableEntry)entry).getParent());
        }
        return false;
    }

    @Nullable
    public AccessFlags getMethodAccess(MethodEntry entry) {
        return this.methods.get(entry);
    }

    @Nullable
    public AccessFlags getFieldAccess(FieldEntry entry) {
        return this.fields.get(entry);
    }

    @Nullable
    public AccessFlags getClassAccess(ClassEntry entry) {
        return this.classes.get(entry);
    }

    @Nullable
    public AccessFlags getEntryAccess(Entry<?> entry) {
        if (entry instanceof MethodEntry) {
            return this.getMethodAccess((MethodEntry)entry);
        }
        if (entry instanceof FieldEntry) {
            return this.getFieldAccess((FieldEntry)entry);
        }
        if (entry instanceof LocalVariableEntry) {
            return this.getMethodAccess((MethodEntry)((LocalVariableEntry)entry).getParent());
        }
        return null;
    }

    public Collection<ClassEntry> getClasses() {
        return this.classes.keySet();
    }

    public Collection<MethodEntry> getMethods() {
        return this.methods.keySet();
    }

    public Collection<FieldEntry> getFields() {
        return this.fields.keySet();
    }
}

