/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.ClassCache;
import cuchaz.enigma.analysis.index.BridgeMethodIndex;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.IndexClassVisitor;
import cuchaz.enigma.analysis.index.IndexReferenceVisitor;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.analysis.index.PackageVisibilityIndex;
import cuchaz.enigma.analysis.index.ReferenceIndex;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.IndexEntryResolver;
import cuchaz.enigma.translation.representation.Lambda;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Arrays;
import java.util.Collection;

public class JarIndex
implements JarIndexer {
    private final EntryIndex entryIndex;
    private final InheritanceIndex inheritanceIndex;
    private final ReferenceIndex referenceIndex;
    private final BridgeMethodIndex bridgeMethodIndex;
    private final PackageVisibilityIndex packageVisibilityIndex;
    private final EntryResolver entryResolver;
    private final Collection<JarIndexer> indexers;
    private final Multimap<String, MethodDefEntry> methodImplementations = HashMultimap.create();

    public JarIndex(EntryIndex entryIndex, InheritanceIndex inheritanceIndex, ReferenceIndex referenceIndex, BridgeMethodIndex bridgeMethodIndex, PackageVisibilityIndex packageVisibilityIndex) {
        this.entryIndex = entryIndex;
        this.inheritanceIndex = inheritanceIndex;
        this.referenceIndex = referenceIndex;
        this.bridgeMethodIndex = bridgeMethodIndex;
        this.packageVisibilityIndex = packageVisibilityIndex;
        this.indexers = Arrays.asList(entryIndex, inheritanceIndex, referenceIndex, bridgeMethodIndex, packageVisibilityIndex);
        this.entryResolver = new IndexEntryResolver(this);
    }

    public static JarIndex empty() {
        EntryIndex entryIndex = new EntryIndex();
        InheritanceIndex inheritanceIndex = new InheritanceIndex(entryIndex);
        ReferenceIndex referenceIndex = new ReferenceIndex();
        BridgeMethodIndex bridgeMethodIndex = new BridgeMethodIndex(entryIndex, inheritanceIndex, referenceIndex);
        PackageVisibilityIndex packageVisibilityIndex = new PackageVisibilityIndex();
        return new JarIndex(entryIndex, inheritanceIndex, referenceIndex, bridgeMethodIndex, packageVisibilityIndex);
    }

    public void indexJar(ClassCache classCache, ProgressListener progress) {
        progress.init(4, "Indexing jar");
        progress.step(1, "Entries...");
        classCache.visit(() -> new IndexClassVisitor(this, 327680), 1);
        progress.step(2, "Entry references...");
        classCache.visit(() -> new IndexReferenceVisitor(this, 327680), 4);
        progress.step(3, "Bridge methods...");
        this.bridgeMethodIndex.findBridgeMethods();
        progress.step(4, "Processing...");
        this.processIndex(this);
    }

    @Override
    public void processIndex(JarIndex index) {
        this.indexers.forEach(indexer -> indexer.processIndex(index));
    }

    @Override
    public void indexClass(ClassDefEntry classEntry) {
        if (classEntry.isJre()) {
            return;
        }
        for (ClassEntry interfaceEntry : classEntry.getInterfaces()) {
            if (!classEntry.equals(interfaceEntry)) continue;
            throw new IllegalArgumentException("Class cannot be its own interface! " + classEntry);
        }
        this.indexers.forEach(indexer -> indexer.indexClass(classEntry));
    }

    @Override
    public void indexField(FieldDefEntry fieldEntry) {
        if (((ClassEntry)fieldEntry.getParent()).isJre()) {
            return;
        }
        this.indexers.forEach(indexer -> indexer.indexField(fieldEntry));
    }

    @Override
    public void indexMethod(MethodDefEntry methodEntry) {
        if (((ClassEntry)methodEntry.getParent()).isJre()) {
            return;
        }
        this.indexers.forEach(indexer -> indexer.indexMethod(methodEntry));
        if (!methodEntry.isConstructor()) {
            this.methodImplementations.put(((ClassEntry)methodEntry.getParent()).getFullName(), methodEntry);
        }
    }

    @Override
    public void indexMethodReference(MethodDefEntry callerEntry, MethodEntry referencedEntry) {
        if (((ClassEntry)callerEntry.getParent()).isJre()) {
            return;
        }
        this.indexers.forEach(indexer -> indexer.indexMethodReference(callerEntry, referencedEntry));
    }

    @Override
    public void indexFieldReference(MethodDefEntry callerEntry, FieldEntry referencedEntry) {
        if (((ClassEntry)callerEntry.getParent()).isJre()) {
            return;
        }
        this.indexers.forEach(indexer -> indexer.indexFieldReference(callerEntry, referencedEntry));
    }

    @Override
    public void indexLambda(MethodDefEntry callerEntry, Lambda lambda) {
        if (((ClassEntry)callerEntry.getParent()).isJre()) {
            return;
        }
        this.indexers.forEach(indexer -> indexer.indexLambda(callerEntry, lambda));
    }

    public EntryIndex getEntryIndex() {
        return this.entryIndex;
    }

    public InheritanceIndex getInheritanceIndex() {
        return this.inheritanceIndex;
    }

    public ReferenceIndex getReferenceIndex() {
        return this.referenceIndex;
    }

    public BridgeMethodIndex getBridgeMethodIndex() {
        return this.bridgeMethodIndex;
    }

    public PackageVisibilityIndex getPackageVisibilityIndex() {
        return this.packageVisibilityIndex;
    }

    public EntryResolver getEntryResolver() {
        return this.entryResolver;
    }
}

