/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode.translators;

import java.util.Stack;
import java.util.function.Function;
import org.objectweb.asm.signature.SignatureVisitor;

public class TranslationSignatureVisitor
extends SignatureVisitor {
    private final Function<String, String> remapper;
    private final SignatureVisitor sv;
    private final Stack<String> classStack = new Stack();

    public TranslationSignatureVisitor(Function<String, String> remapper, SignatureVisitor sv) {
        super(327680);
        this.remapper = remapper;
        this.sv = sv;
    }

    @Override
    public void visitClassType(String name) {
        this.classStack.push(name);
        String translatedEntry = this.remapper.apply(name);
        this.sv.visitClassType(translatedEntry);
    }

    @Override
    public void visitInnerClassType(String name) {
        String translatedEntry;
        String lastClass = this.classStack.pop();
        if (!name.startsWith(lastClass + "$")) {
            name = lastClass + "$" + name;
        }
        if ((translatedEntry = this.remapper.apply(name)).contains("/")) {
            translatedEntry = translatedEntry.substring(translatedEntry.lastIndexOf("/") + 1);
        }
        if (translatedEntry.contains("$")) {
            translatedEntry = translatedEntry.substring(translatedEntry.lastIndexOf("$") + 1);
        }
        this.sv.visitInnerClassType(translatedEntry);
    }

    @Override
    public void visitFormalTypeParameter(String name) {
        this.sv.visitFormalTypeParameter(name);
    }

    @Override
    public void visitTypeVariable(String name) {
        this.sv.visitTypeVariable(name);
    }

    @Override
    public SignatureVisitor visitArrayType() {
        this.sv.visitArrayType();
        return this;
    }

    @Override
    public void visitBaseType(char descriptor) {
        this.sv.visitBaseType(descriptor);
    }

    @Override
    public SignatureVisitor visitClassBound() {
        this.sv.visitClassBound();
        return this;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        this.sv.visitExceptionType();
        return this;
    }

    @Override
    public SignatureVisitor visitInterface() {
        this.sv.visitInterface();
        return this;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        this.sv.visitInterfaceBound();
        return this;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        this.sv.visitParameterType();
        return this;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        this.sv.visitReturnType();
        return this;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        this.sv.visitSuperclass();
        return this;
    }

    @Override
    public void visitTypeArgument() {
        this.sv.visitTypeArgument();
    }

    @Override
    public SignatureVisitor visitTypeArgument(char wildcard) {
        this.sv.visitTypeArgument(wildcard);
        return this;
    }

    @Override
    public void visitEnd() {
        this.sv.visitEnd();
        if (!this.classStack.empty()) {
            this.classStack.pop();
        }
    }

    public String toString() {
        return this.sv.toString();
    }
}

