/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.command;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.command.Command;
import java.nio.file.Path;

public class DecompileCommand
extends Command {
    public DecompileCommand() {
        super("decompile");
    }

    @Override
    public String getUsage() {
        return "<in jar> <out folder> [<mappings file>]";
    }

    @Override
    public boolean isValidArgument(int length) {
        return length == 2 || length == 3;
    }

    @Override
    public void run(String ... args) throws Exception {
        Path fileJarIn = DecompileCommand.getReadableFile(DecompileCommand.getArg(args, 0, "in jar", true)).toPath();
        Path fileJarOut = DecompileCommand.getWritableFolder(DecompileCommand.getArg(args, 1, "out folder", true)).toPath();
        Path fileMappings = DecompileCommand.getReadablePath(DecompileCommand.getArg(args, 2, "mappings file", false));
        EnigmaProject project = DecompileCommand.openProject(fileJarIn, fileMappings);
        Command.ConsoleProgressListener progress = new Command.ConsoleProgressListener();
        EnigmaProject.JarExport jar = project.exportRemappedJar(progress);
        EnigmaProject.SourceExport source = jar.decompile(progress);
        source.write(fileJarOut, progress);
    }
}

