/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import com.google.common.collect.Lists;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import me.xdrop.fuzzywuzzy.FuzzySearch;
import me.xdrop.fuzzywuzzy.model.ExtractedResult;

public class SearchDialog {
    private JTextField searchField;
    private JList<String> classList;
    private JFrame frame;
    private Gui parent;
    private List<ClassEntry> deobfClasses;
    private KeyEventDispatcher keyEventDispatcher;

    public SearchDialog(Gui parent) {
        this.parent = parent;
        this.deobfClasses = Lists.newArrayList();
        this.parent.getController().addSeparatedClasses(Lists.newArrayList(), this.deobfClasses);
        this.deobfClasses.removeIf(ClassEntry::isInnerClass);
    }

    public void show() {
        this.frame = new JFrame("Search");
        this.frame.setVisible(false);
        JPanel pane = new JPanel();
        pane.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.addRow(pane, jPanel -> {
            this.searchField = new JTextField("", 20);
            this.searchField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    SearchDialog.this.updateList();
                }
            });
            jPanel.add(this.searchField);
        });
        this.addRow(pane, jPanel -> {
            this.classList = new JList();
            this.classList.setLayoutOrientation(0);
            this.classList.setSelectionMode(0);
            this.classList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() >= 2) {
                        SearchDialog.this.openSelected();
                    }
                }
            });
            jPanel.add(this.classList);
        });
        this.keyEventDispatcher = keyEvent -> {
            int next;
            if (!this.frame.isVisible()) {
                return false;
            }
            if (keyEvent.getKeyCode() == 40) {
                next = this.classList.isSelectionEmpty() ? 0 : this.classList.getSelectedIndex() + 1;
                this.classList.setSelectedIndex(next);
            }
            if (keyEvent.getKeyCode() == 38) {
                next = this.classList.isSelectionEmpty() ? this.classList.getModel().getSize() : this.classList.getSelectedIndex() - 1;
                this.classList.setSelectedIndex(next);
            }
            if (keyEvent.getKeyCode() == 10) {
                this.openSelected();
            }
            if (keyEvent.getKeyCode() == 27) {
                this.close();
            }
            return false;
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
        this.frame.setContentPane(pane);
        this.frame.setLayout(new BoxLayout(pane, 1));
        this.frame.setSize(360, 500);
        this.frame.setAlwaysOnTop(true);
        this.frame.setResizable(false);
        this.frame.setLocationRelativeTo(this.parent.getFrame());
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(2);
        this.searchField.requestFocusInWindow();
    }

    private void openSelected() {
        this.close();
        if (this.classList.isSelectionEmpty()) {
            return;
        }
        this.deobfClasses.stream().filter(classEntry -> classEntry.getSimpleName().equals(this.classList.getSelectedValue())).findFirst().ifPresent(classEntry -> {
            this.parent.getController().navigateTo((Entry<?>)classEntry);
            this.parent.getDeobfPanel().deobfClasses.setSelectionClass((ClassEntry)classEntry);
        });
    }

    private void close() {
        this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
    }

    private void addRow(JPanel pane, Consumer<JPanel> consumer) {
        JPanel panel = new JPanel(new FlowLayout());
        consumer.accept(panel);
        pane.add((Component)panel, "Center");
    }

    private void updateList() {
        DefaultListModel listModel = new DefaultListModel();
        List<ExtractedResult> results = FuzzySearch.extractTop(this.searchField.getText(), this.deobfClasses.stream().map(ClassEntry::getSimpleName).collect(Collectors.toList()), 25);
        results.forEach(extractedResult -> listModel.addElement(extractedResult.getString()));
        this.classList.setModel(listModel);
    }
}

