/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.MappingTranslator;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.MappingValidator;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.mapping.tree.DeltaTrackingTree;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class EntryRemapper {
    private final DeltaTrackingTree<EntryMapping> obfToDeobf;
    private final EntryResolver obfResolver;
    private final Translator deobfuscator;
    private final MappingValidator validator;

    private EntryRemapper(JarIndex jarIndex, EntryTree<EntryMapping> obfToDeobf) {
        this.obfToDeobf = new DeltaTrackingTree<EntryMapping>(obfToDeobf);
        this.obfResolver = jarIndex.getEntryResolver();
        this.deobfuscator = new MappingTranslator(obfToDeobf, this.obfResolver);
        this.validator = new MappingValidator(obfToDeobf, this.deobfuscator, jarIndex);
    }

    public static EntryRemapper mapped(JarIndex index, EntryTree<EntryMapping> obfToDeobf) {
        return new EntryRemapper(index, obfToDeobf);
    }

    public static EntryRemapper empty(JarIndex index) {
        return new EntryRemapper(index, new HashEntryTree<EntryMapping>());
    }

    public <E extends Entry<?>> void mapFromObf(E obfuscatedEntry, @Nullable EntryMapping deobfMapping) {
        Collection<E> resolvedEntries = this.obfResolver.resolveEntry(obfuscatedEntry, ResolutionStrategy.RESOLVE_ROOT);
        if (deobfMapping != null) {
            for (E resolvedEntry : resolvedEntries) {
                this.validator.validateRename(resolvedEntry, deobfMapping.getTargetName());
            }
        }
        for (E resolvedEntry : resolvedEntries) {
            this.obfToDeobf.insert(resolvedEntry, deobfMapping);
        }
    }

    public void removeByObf(Entry<?> obfuscatedEntry) {
        this.mapFromObf(obfuscatedEntry, null);
    }

    @Nullable
    public EntryMapping getDeobfMapping(Entry<?> entry) {
        return this.obfToDeobf.get(entry);
    }

    public boolean hasDeobfMapping(Entry<?> obfEntry) {
        return this.obfToDeobf.contains(obfEntry);
    }

    public <T extends Translatable> T deobfuscate(T translatable) {
        return this.deobfuscator.translate(translatable);
    }

    public Translator getDeobfuscator() {
        return this.deobfuscator;
    }

    public Stream<Entry<?>> getObfEntries() {
        return this.obfToDeobf.getAllEntries();
    }

    public Collection<Entry<?>> getObfChildren(Entry<?> obfuscatedEntry) {
        return this.obfToDeobf.getChildren(obfuscatedEntry);
    }

    public DeltaTrackingTree<EntryMapping> getObfToDeobf() {
        return this.obfToDeobf;
    }

    public MappingDelta<EntryMapping> takeMappingDelta() {
        return this.obfToDeobf.takeDelta();
    }

    public boolean isDirty() {
        return this.obfToDeobf.isDirty();
    }

    public EntryResolver getObfResolver() {
        return this.obfResolver;
    }
}

