/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde;

import com.google.common.base.Charsets;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.throwables.MappingParseException;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingPair;
import cuchaz.enigma.translation.mapping.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.serde.MappingsReader;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public enum EnigmaMappingsReader implements MappingsReader
{
    FILE{

        @Override
        public EntryTree<EntryMapping> read(Path path, ProgressListener progress, MappingSaveParameters saveParameters) throws IOException, MappingParseException {
            progress.init(1, "Loading mapping file");
            HashEntryTree<EntryMapping> mappings = new HashEntryTree<EntryMapping>();
            this.readFile(path, mappings);
            progress.step(1, "Done!");
            return mappings;
        }
    }
    ,
    DIRECTORY{

        @Override
        public EntryTree<EntryMapping> read(Path root, ProgressListener progress, MappingSaveParameters saveParameters) throws IOException, MappingParseException {
            HashEntryTree<EntryMapping> mappings = new HashEntryTree<EntryMapping>();
            List files = Files.walk(root, new FileVisitOption[0]).filter(f -> !Files.isDirectory(f, new LinkOption[0])).filter(f -> f.toString().endsWith(".mapping")).collect(Collectors.toList());
            progress.init(files.size(), "Loading mapping files");
            int step = 0;
            for (Path file : files) {
                progress.step(step++, root.relativize(file).toString());
                if (Files.isHidden(file)) continue;
                this.readFile(file, mappings);
            }
            return mappings;
        }
    };


    protected void readFile(Path path, EntryTree<EntryMapping> mappings) throws IOException, MappingParseException {
        List<String> lines = Files.readAllLines(path, Charsets.UTF_8);
        ArrayDeque mappingStack = new ArrayDeque();
        for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber);
            int indentation = this.countIndentation(line);
            if ((line = this.formatLine(line)) == null) continue;
            while (indentation < mappingStack.size()) {
                mappingStack.pop();
            }
            try {
                MappingPair<?, EntryMapping> pair = this.parseLine((Entry)mappingStack.peek(), line);
                mappingStack.push(pair.getEntry());
                if (pair.getMapping() == null) continue;
                mappings.insert((Entry<?>)pair.getEntry(), pair.getMapping());
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new MappingParseException(path::toString, lineNumber, t.toString());
            }
        }
    }

    @Nullable
    private String formatLine(String line) {
        line = this.stripComment(line);
        if ((line = line.trim()).isEmpty()) {
            return null;
        }
        return line;
    }

    private String stripComment(String line) {
        int commentPos = line.indexOf(35);
        if (commentPos >= 0) {
            return line.substring(0, commentPos);
        }
        return line;
    }

    private int countIndentation(String line) {
        int indent = 0;
        for (int i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++indent;
        }
        return indent;
    }

    private MappingPair<?, EntryMapping> parseLine(@Nullable Entry<?> parent, String line) {
        String keyToken;
        String[] tokens = line.trim().split("\\s");
        switch (keyToken = tokens[0].toLowerCase(Locale.ROOT)) {
            case "class": {
                return this.parseClass(parent, tokens);
            }
            case "field": {
                return this.parseField(parent, tokens);
            }
            case "method": {
                return this.parseMethod(parent, tokens);
            }
            case "arg": {
                return this.parseArgument(parent, tokens);
            }
        }
        throw new RuntimeException("Unknown token '" + keyToken + "'");
    }

    private MappingPair<ClassEntry, EntryMapping> parseClass(@Nullable Entry<?> parent, String[] tokens) {
        String obfuscatedName = ClassEntry.getInnerName(tokens[1]);
        ClassEntry obfuscatedEntry = parent instanceof ClassEntry ? new ClassEntry((ClassEntry)parent, obfuscatedName) : new ClassEntry(obfuscatedName);
        String mapping = null;
        AccessModifier modifier = AccessModifier.UNCHANGED;
        if (tokens.length == 3) {
            AccessModifier parsedModifier = this.parseModifier(tokens[2]);
            if (parsedModifier != null) {
                modifier = parsedModifier;
                mapping = obfuscatedName;
            } else {
                mapping = tokens[2];
            }
        } else if (tokens.length == 4) {
            mapping = tokens[2];
            modifier = this.parseModifier(tokens[3]);
        }
        if (mapping != null) {
            return new MappingPair<ClassEntry, EntryMapping>(obfuscatedEntry, new EntryMapping(mapping, modifier));
        }
        return new MappingPair<ClassEntry, EntryMapping>(obfuscatedEntry);
    }

    private MappingPair<FieldEntry, EntryMapping> parseField(@Nullable Entry<?> parent, String[] tokens) {
        TypeDescriptor descriptor;
        String obfuscatedName;
        if (!(parent instanceof ClassEntry)) {
            throw new RuntimeException("Field must be a child of a class!");
        }
        ClassEntry ownerEntry = (ClassEntry)parent;
        String mapping = obfuscatedName = tokens[1];
        AccessModifier modifier = AccessModifier.UNCHANGED;
        if (tokens.length == 4) {
            AccessModifier parsedModifier = this.parseModifier(tokens[3]);
            if (parsedModifier != null) {
                descriptor = new TypeDescriptor(tokens[2]);
                modifier = parsedModifier;
            } else {
                mapping = tokens[2];
                descriptor = new TypeDescriptor(tokens[3]);
            }
        } else if (tokens.length == 5) {
            descriptor = new TypeDescriptor(tokens[3]);
            mapping = tokens[2];
            modifier = this.parseModifier(tokens[4]);
        } else {
            throw new RuntimeException("Invalid field declaration");
        }
        FieldEntry obfuscatedEntry = new FieldEntry(ownerEntry, obfuscatedName, descriptor);
        if (mapping != null) {
            return new MappingPair<FieldEntry, EntryMapping>(obfuscatedEntry, new EntryMapping(mapping, modifier));
        }
        return new MappingPair<FieldEntry, EntryMapping>(obfuscatedEntry);
    }

    private MappingPair<MethodEntry, EntryMapping> parseMethod(@Nullable Entry<?> parent, String[] tokens) {
        MethodDescriptor descriptor;
        if (!(parent instanceof ClassEntry)) {
            throw new RuntimeException("Method must be a child of a class!");
        }
        ClassEntry ownerEntry = (ClassEntry)parent;
        String obfuscatedName = tokens[1];
        String mapping = null;
        AccessModifier modifier = AccessModifier.UNCHANGED;
        if (tokens.length == 3) {
            descriptor = new MethodDescriptor(tokens[2]);
        } else if (tokens.length == 4) {
            AccessModifier parsedModifier = this.parseModifier(tokens[3]);
            if (parsedModifier != null) {
                modifier = parsedModifier;
                mapping = obfuscatedName;
                descriptor = new MethodDescriptor(tokens[2]);
            } else {
                mapping = tokens[2];
                descriptor = new MethodDescriptor(tokens[3]);
            }
        } else if (tokens.length == 5) {
            mapping = tokens[2];
            modifier = this.parseModifier(tokens[4]);
            descriptor = new MethodDescriptor(tokens[3]);
        } else {
            throw new RuntimeException("Invalid method declaration");
        }
        MethodEntry obfuscatedEntry = new MethodEntry(ownerEntry, obfuscatedName, descriptor);
        if (mapping != null) {
            return new MappingPair<MethodEntry, EntryMapping>(obfuscatedEntry, new EntryMapping(mapping, modifier));
        }
        return new MappingPair<MethodEntry, EntryMapping>(obfuscatedEntry);
    }

    private MappingPair<LocalVariableEntry, EntryMapping> parseArgument(@Nullable Entry<?> parent, String[] tokens) {
        if (!(parent instanceof MethodEntry)) {
            throw new RuntimeException("Method arg must be a child of a method!");
        }
        MethodEntry ownerEntry = (MethodEntry)parent;
        LocalVariableEntry obfuscatedEntry = new LocalVariableEntry(ownerEntry, Integer.parseInt(tokens[1]), "", true);
        String mapping = tokens[2];
        return new MappingPair<LocalVariableEntry, EntryMapping>(obfuscatedEntry, new EntryMapping(mapping));
    }

    @Nullable
    private AccessModifier parseModifier(String token) {
        if (token.startsWith("ACC:")) {
            return AccessModifier.valueOf(token.substring(4));
        }
        return null;
    }
}

