/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane.actions;

import de.sciss.syntaxpane.SyntaxDocument;
import de.sciss.syntaxpane.actions.ActionUtils;
import de.sciss.syntaxpane.actions.SyntaxAction;
import de.sciss.syntaxpane.util.Configuration;
import de.sciss.syntaxpane.util.ReflectUtils;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public abstract class DefaultSyntaxAction
extends TextAction
implements SyntaxAction {
    public static final String ACTION_PREFIX = "Action.";
    public static final String SMALL_ICONS_LOC_PREFIX = "de/sciss/syntaxpane/images/small-icons/";
    public static final String LARGE_ICONS_LOC_PREFIX = "de/sciss/syntaxpane/images/large-icons/";

    public DefaultSyntaxAction(String actionName) {
        super(actionName);
        this.putValue("Name", actionName);
    }

    @Override
    public void install(JEditorPane editor, Configuration config, String name) {
        String actionName = name.substring(ACTION_PREFIX.length());
        for (Configuration.StringKeyMatcher m3 : config.getKeys(Pattern.compile(Pattern.quote(name) + "\\.((\\w|-)+)"))) {
            if (ReflectUtils.callSetter(this, m3.group1, m3.value)) continue;
            this.putValue(m3.group1, m3.value);
        }
        if (this.getValue("Name") == null) {
            this.putValue("Name", actionName);
        }
        if (this.getValue("SmallIcon") == null) {
            this.setSmallIcon(actionName + ".png");
        }
    }

    @Override
    public void deinstall(JEditorPane editor) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent text = this.getTextComponent(e);
        SyntaxDocument sdoc = ActionUtils.getSyntaxDocument(text);
        if (text != null) {
            this.actionPerformed(text, sdoc, text.getCaretPosition(), e);
        }
    }

    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String toString() {
        return "Action " + this.getValue("Name") + "of type " + this.getClass().getSimpleName();
    }

    public final void setMenuText(String text) {
        this.putValue("Name", text);
        if (this.getValue("ShortDescription") == null) {
            this.putValue("ShortDescription", text);
        }
    }

    public final void setToolTip(String text) {
        this.putValue("ShortDescription", text);
    }

    public final void setLargeIcon(String url) {
        URL loc = this.getClass().getClassLoader().getResource(LARGE_ICONS_LOC_PREFIX + url);
        if (loc != null) {
            ImageIcon i = new ImageIcon(loc);
            this.putValue("SwingLargeIconKey", i);
        }
    }

    public final void setSmallIcon(String url) {
        URL loc = this.getClass().getClassLoader().getResource(SMALL_ICONS_LOC_PREFIX + url);
        if (loc != null) {
            ImageIcon i = new ImageIcon(loc);
            this.putValue("SmallIcon", i);
        }
    }
}

