/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class InterpreterPair<V extends Value, W extends Value>
extends Interpreter<PairValue<V, W>> {
    private final Interpreter<V> left;
    private final Interpreter<W> right;

    public InterpreterPair(Interpreter<V> left, Interpreter<W> right) {
        super(524288);
        this.left = left;
        this.right = right;
    }

    public PairValue<V, W> newValue(Type type) {
        return this.pair(this.left.newValue(type), this.right.newValue(type));
    }

    public PairValue<V, W> newOperation(AbstractInsnNode insn) throws AnalyzerException {
        return this.pair(this.left.newOperation(insn), this.right.newOperation(insn));
    }

    public PairValue<V, W> copyOperation(AbstractInsnNode insn, PairValue<V, W> value) throws AnalyzerException {
        return this.pair(this.left.copyOperation(insn, value.left), this.right.copyOperation(insn, value.right));
    }

    public PairValue<V, W> unaryOperation(AbstractInsnNode insn, PairValue<V, W> value) throws AnalyzerException {
        return this.pair(this.left.unaryOperation(insn, value.left), this.right.unaryOperation(insn, value.right));
    }

    public PairValue<V, W> binaryOperation(AbstractInsnNode insn, PairValue<V, W> value1, PairValue<V, W> value2) throws AnalyzerException {
        return this.pair(this.left.binaryOperation(insn, value1.left, value2.left), this.right.binaryOperation(insn, value1.right, value2.right));
    }

    public PairValue<V, W> ternaryOperation(AbstractInsnNode insn, PairValue<V, W> value1, PairValue<V, W> value2, PairValue<V, W> value3) throws AnalyzerException {
        return this.pair(this.left.ternaryOperation(insn, value1.left, value2.left, value3.left), this.right.ternaryOperation(insn, value1.right, value2.right, value3.right));
    }

    public PairValue<V, W> naryOperation(AbstractInsnNode insn, List<? extends PairValue<V, W>> values) throws AnalyzerException {
        return this.pair(this.left.naryOperation(insn, values.stream().map(v -> v.left).collect(Collectors.toList())), this.right.naryOperation(insn, values.stream().map(v -> v.right).collect(Collectors.toList())));
    }

    public void returnOperation(AbstractInsnNode insn, PairValue<V, W> value, PairValue<V, W> expected) throws AnalyzerException {
        this.left.returnOperation(insn, value.left, expected.left);
        this.right.returnOperation(insn, value.right, expected.right);
    }

    public PairValue<V, W> merge(PairValue<V, W> value1, PairValue<V, W> value2) {
        return this.pair(this.left.merge(value1.left, value2.left), this.right.merge(value1.right, value2.right));
    }

    private PairValue<V, W> pair(V left, W right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right != null && left.getSize() != right.getSize()) {
            throw new IllegalStateException("sizes don't match");
        }
        return new PairValue<V, W>(left, right);
    }

    public static final class PairValue<V extends Value, W extends Value>
    implements Value {
        public final V left;
        public final W right;

        public PairValue(V left, W right) {
            if (left == null && right == null) {
                throw new IllegalArgumentException("should use null rather than pair of nulls");
            }
            if (left != null && right != null && left.getSize() != right.getSize()) {
                throw new IllegalArgumentException("sizes don't match");
            }
            this.left = left;
            this.right = right;
        }

        public boolean equals(Object o) {
            return o instanceof PairValue && Objects.equals(this.left, ((PairValue)o).left) && Objects.equals(this.right, ((PairValue)o).right);
        }

        public int hashCode() {
            return this.left.hashCode() * 31 + this.right.hashCode();
        }

        public int getSize() {
            return (this.left == null ? this.right : this.left).getSize();
        }
    }
}

