/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

public class Token
implements Comparable<Token> {
    public int start;
    public int end;
    public String text;

    public Token(int start, int end, String text) {
        this.start = start;
        this.end = end;
        this.text = text;
    }

    public int getRenameOffset(String to) {
        int length = this.end - this.start;
        return to.length() - length;
    }

    public void rename(StringBuffer source, String to) {
        int oldEnd = this.end;
        this.text = to;
        this.end = this.start + to.length();
        source.replace(this.start, oldEnd, to);
    }

    public Token move(int offset) {
        Token token = new Token(this.start + offset, this.end + offset, null);
        token.text = this.text;
        return token;
    }

    public boolean contains(int pos) {
        return pos >= this.start && pos <= this.end;
    }

    @Override
    public int compareTo(Token other) {
        return this.start - other.start;
    }

    public boolean equals(Object other) {
        return other instanceof Token && this.equals((Token)other);
    }

    public int hashCode() {
        return this.start * 37 + this.end;
    }

    public boolean equals(Token other) {
        return this.start == other.start && this.end == other.end && this.text.equals(other.text);
    }

    public String toString() {
        return String.format("[%d,%d]", this.start, this.end);
    }
}

