/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.command;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.ClassCache;
import cuchaz.enigma.analysis.index.BridgeMethodIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.command.Command;
import cuchaz.enigma.command.MappingCommandsUtil;
import cuchaz.enigma.throwables.MappingParseException;
import cuchaz.enigma.translation.MappingTranslator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingFileNameFormat;
import cuchaz.enigma.translation.mapping.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.Utils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class MapSpecializedMethodsCommand
extends Command {
    public MapSpecializedMethodsCommand() {
        super("map-specialized-methods");
    }

    @Override
    public String getUsage() {
        return "<jar> <source-format> <source> <result-format> <result>";
    }

    @Override
    public boolean isValidArgument(int length) {
        return length == 5;
    }

    @Override
    public void run(String ... args) throws IOException, MappingParseException {
        MapSpecializedMethodsCommand.run(Paths.get(args[0], new String[0]), args[1], Paths.get(args[2], new String[0]), args[3], Paths.get(args[4], new String[0]));
    }

    public static void run(Path jar, String sourceFormat, Path sourcePath, String resultFormat, Path output) throws IOException, MappingParseException {
        MappingSaveParameters saveParameters = new MappingSaveParameters(MappingFileNameFormat.BY_DEOBF);
        EntryTree<EntryMapping> source = MappingCommandsUtil.read(sourceFormat, sourcePath, saveParameters);
        HashEntryTree<EntryMapping> result = new HashEntryTree<EntryMapping>();
        ClassCache classCache = ClassCache.of(jar);
        JarIndex jarIndex = classCache.index(ProgressListener.none());
        BridgeMethodIndex bridgeMethodIndex = jarIndex.getBridgeMethodIndex();
        MappingTranslator translator = new MappingTranslator(source, jarIndex.getEntryResolver());
        for (EntryTreeNode entryTreeNode : source) {
            if (entryTreeNode.getEntry() instanceof MethodEntry && bridgeMethodIndex.isSpecializedMethod((MethodEntry)entryTreeNode.getEntry())) continue;
            result.insert(entryTreeNode.getEntry(), (EntryMapping)entryTreeNode.getValue());
        }
        for (Map.Entry entry : bridgeMethodIndex.getBridgeToSpecialized().entrySet()) {
            MethodEntry bridge = (MethodEntry)entry.getKey();
            MethodEntry specialized = (MethodEntry)entry.getValue();
            String name = translator.translate(bridge).getName();
            result.insert(specialized, new EntryMapping(name));
        }
        Utils.delete(output);
        MappingCommandsUtil.write(result, resultFormat, output, saveParameters);
    }
}

