/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.procyon.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import cuchaz.enigma.source.SourceIndex;
import cuchaz.enigma.source.procyon.EntryParser;
import cuchaz.enigma.source.procyon.index.SourceIndexVisitor;
import cuchaz.enigma.source.procyon.index.TokenFactory;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.HashMap;
import java.util.Map;

public class SourceIndexMethodVisitor
extends SourceIndexVisitor {
    private final MethodDefEntry methodEntry;
    private Multimap<String, Identifier> unmatchedIdentifier = HashMultimap.create();
    private Map<String, Entry<?>> identifierEntryCache = new HashMap();

    public SourceIndexMethodVisitor(MethodDefEntry methodEntry) {
        this.methodEntry = methodEntry;
    }

    public Void visitInvocationExpression(InvocationExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
        MethodEntry methodEntry = null;
        if (ref instanceof MethodReference) {
            methodEntry = new MethodEntry(classEntry, ref.getName(), new MethodDescriptor(ref.getErasedSignature()));
        }
        if (methodEntry != null) {
            Identifier tokenNode = null;
            if (node.getTarget() instanceof MemberReferenceExpression) {
                tokenNode = ((MemberReferenceExpression)node.getTarget()).getMemberNameToken();
            } else if (node.getTarget() instanceof SuperReferenceExpression) {
                tokenNode = node.getTarget();
            } else if (node.getTarget() instanceof ThisReferenceExpression) {
                tokenNode = node.getTarget();
            }
            if (tokenNode != null) {
                index.addReference(TokenFactory.createToken(index, (AstNode)tokenNode), methodEntry, this.methodEntry);
            }
        }
        node.getArguments().stream().filter(expression -> expression instanceof IdentifierExpression).forEach(expression -> this.checkIdentifier((IdentifierExpression)expression, index));
        return this.visitChildren((AstNode)node, index);
    }

    public Void visitMemberReferenceExpression(MemberReferenceExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref instanceof FieldReference) {
            String erasedSignature = ref.getErasedSignature();
            if (erasedSignature.indexOf(40) >= 0) {
                throw new Error("Expected a field here! got " + ref);
            }
            ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
            FieldEntry fieldEntry = new FieldEntry(classEntry, ref.getName(), new TypeDescriptor(erasedSignature));
            index.addReference(TokenFactory.createToken(index, (AstNode)node.getMemberNameToken()), fieldEntry, this.methodEntry);
        }
        return this.visitChildren((AstNode)node, index);
    }

    public Void visitSimpleType(SimpleType node, SourceIndex index) {
        TypeReference ref = (TypeReference)node.getUserData(Keys.TYPE_REFERENCE);
        if (node.getIdentifierToken().getStartLocation() != TextLocation.EMPTY) {
            ClassEntry classEntry = new ClassEntry(ref.getInternalName());
            index.addReference(TokenFactory.createToken(index, (AstNode)node.getIdentifierToken()), classEntry, this.methodEntry);
        }
        return this.visitChildren((AstNode)node, index);
    }

    public Void visitParameterDeclaration(ParameterDeclaration node, SourceIndex index) {
        ParameterDefinition def = (ParameterDefinition)node.getUserData(Keys.PARAMETER_DEFINITION);
        int parameterIndex = def.getSlot();
        if (parameterIndex >= 0) {
            MethodDefEntry ownerMethod = this.methodEntry;
            if (def.getMethod() instanceof MethodDefinition) {
                ownerMethod = EntryParser.parse((MethodDefinition)def.getMethod());
            }
            TypeDescriptor parameterType = EntryParser.parseTypeDescriptor(def.getParameterType());
            LocalVariableDefEntry localVariableEntry = new LocalVariableDefEntry(ownerMethod, parameterIndex, node.getName(), true, parameterType, null);
            Identifier identifier = node.getNameToken();
            this.identifierEntryCache.put(identifier.getName(), localVariableEntry);
            index.addDeclaration(TokenFactory.createToken(index, (AstNode)identifier), localVariableEntry);
        }
        return this.visitChildren((AstNode)node, index);
    }

    public Void visitIdentifierExpression(IdentifierExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref != null) {
            ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
            FieldEntry fieldEntry = new FieldEntry(classEntry, ref.getName(), new TypeDescriptor(ref.getErasedSignature()));
            index.addReference(TokenFactory.createToken(index, (AstNode)node.getIdentifierToken()), fieldEntry, this.methodEntry);
        } else {
            this.checkIdentifier(node, index);
        }
        return this.visitChildren((AstNode)node, index);
    }

    private void checkIdentifier(IdentifierExpression node, SourceIndex index) {
        if (this.identifierEntryCache.containsKey(node.getIdentifier())) {
            index.addDeclaration(TokenFactory.createToken(index, (AstNode)node.getIdentifierToken()), this.identifierEntryCache.get(node.getIdentifier()));
        } else {
            this.unmatchedIdentifier.put((Object)node.getIdentifier(), (Object)node.getIdentifierToken());
        }
    }

    private void addDeclarationToUnmatched(String key, SourceIndex index) {
        Entry<?> entry = this.identifierEntryCache.get(key);
        if (entry == null) {
            return;
        }
        for (Identifier identifier : this.unmatchedIdentifier.get((Object)key)) {
            index.addDeclaration(TokenFactory.createToken(index, (AstNode)identifier), entry);
        }
        this.unmatchedIdentifier.removeAll((Object)key);
    }

    public Void visitObjectCreationExpression(ObjectCreationExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref != null && node.getType() instanceof SimpleType) {
            SimpleType simpleTypeNode = (SimpleType)node.getType();
            ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
            MethodEntry constructorEntry = new MethodEntry(classEntry, "<init>", new MethodDescriptor(ref.getErasedSignature()));
            index.addReference(TokenFactory.createToken(index, (AstNode)simpleTypeNode.getIdentifierToken()), constructorEntry, this.methodEntry);
        }
        return this.visitChildren((AstNode)node, index);
    }

    public Void visitVariableDeclaration(VariableDeclarationStatement node, SourceIndex index) {
        VariableInitializer initializer;
        AstNodeCollection variables = node.getVariables();
        if (variables.size() == 1 && (initializer = (VariableInitializer)variables.firstOrNullObject()) != null && node.getType() instanceof SimpleType) {
            int variableIndex;
            VariableDefinition originalVariable;
            Identifier identifier = initializer.getNameToken();
            Variable variable = (Variable)initializer.getUserData(Keys.VARIABLE);
            if (variable != null && (originalVariable = variable.getOriginalVariable()) != null && (variableIndex = originalVariable.getSlot()) >= 0) {
                MethodDefEntry ownerMethod = EntryParser.parse(originalVariable.getDeclaringMethod());
                TypeDescriptor variableType = EntryParser.parseTypeDescriptor(originalVariable.getVariableType());
                LocalVariableDefEntry localVariableEntry = new LocalVariableDefEntry(ownerMethod, variableIndex, initializer.getName(), false, variableType, null);
                this.identifierEntryCache.put(identifier.getName(), localVariableEntry);
                this.addDeclarationToUnmatched(identifier.getName(), index);
                index.addDeclaration(TokenFactory.createToken(index, (AstNode)identifier), localVariableEntry);
            }
        }
        return this.visitChildren((AstNode)node, index);
    }

    public Void visitMethodGroupExpression(MethodGroupExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref instanceof MethodReference) {
            ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
            MethodEntry methodEntry = new MethodEntry(classEntry, ref.getName(), new MethodDescriptor(ref.getErasedSignature()));
            Identifier methodNameToken = node.getMethodNameToken();
            Expression targetToken = node.getTarget();
            if (methodNameToken != null) {
                index.addReference(TokenFactory.createToken(index, (AstNode)methodNameToken), methodEntry, this.methodEntry);
            }
            if (targetToken != null && !(targetToken instanceof ThisReferenceExpression)) {
                index.addReference(TokenFactory.createToken(index, (AstNode)targetToken), (Entry<?>)methodEntry.getParent(), this.methodEntry);
            }
        }
        return this.visitChildren((AstNode)node, index);
    }
}

