/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.throwables.IllegalNameException;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class MappingValidator {
    private final EntryTree<EntryMapping> obfToDeobf;
    private final Translator deobfuscator;
    private final JarIndex index;

    public MappingValidator(EntryTree<EntryMapping> obfToDeobf, Translator deobfuscator, JarIndex index) {
        this.obfToDeobf = obfToDeobf;
        this.deobfuscator = deobfuscator;
        this.index = index;
    }

    public void validateRename(Entry<?> entry, String name) throws IllegalNameException {
        Set<Entry<?>> equivalentEntries = this.index.getEntryResolver().resolveEquivalentEntries(entry);
        for (Entry entry2 : equivalentEntries) {
            entry2.validateName(name);
            this.validateUnique(entry2, name);
        }
    }

    private void validateUnique(Entry<?> entry, String name) {
        ClassEntry containingClass = entry.getContainingClass();
        Collection<ClassEntry> relatedClasses = this.getRelatedClasses(containingClass);
        for (ClassEntry relatedClass : relatedClasses) {
            Entry<?> relatedEntry = entry.replaceAncestor(containingClass, relatedClass);
            Entry<?> translatedEntry = this.deobfuscator.translate(relatedEntry);
            Collection translatedSiblings = this.obfToDeobf.getSiblings(relatedEntry).stream().map(this.deobfuscator::translate).collect(Collectors.toList());
            if (this.isUnique(translatedEntry, translatedSiblings, name)) continue;
            Object parent = translatedEntry.getParent();
            if (parent != null) {
                throw new IllegalNameException(name, "Name is not unique in " + parent + "!");
            }
            throw new IllegalNameException(name, "Name is not unique!");
        }
    }

    private Collection<ClassEntry> getRelatedClasses(ClassEntry classEntry) {
        InheritanceIndex inheritanceIndex = this.index.getInheritanceIndex();
        HashSet<ClassEntry> relatedClasses = new HashSet<ClassEntry>();
        relatedClasses.add(classEntry);
        relatedClasses.addAll(inheritanceIndex.getChildren(classEntry));
        relatedClasses.addAll(inheritanceIndex.getAncestors(classEntry));
        return relatedClasses;
    }

    private boolean isUnique(Entry<?> entry, Collection<Entry<?>> siblings, String name) {
        for (Entry<?> sibling : siblings) {
            if (!entry.canConflictWith(sibling) || !sibling.getName().equals(name)) continue;
            return false;
        }
        return true;
    }
}

