/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde;

import com.google.common.collect.Lists;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.translation.MappingTranslator;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.VoidEntryResolver;
import cuchaz.enigma.translation.mapping.serde.MappingsWriter;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.LFPrintWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public enum SrgMappingsWriter implements MappingsWriter
{
    INSTANCE;


    @Override
    public void write(EntryTree<EntryMapping> mappings, MappingDelta<EntryMapping> delta, Path path, ProgressListener progress, MappingSaveParameters saveParameters) {
        try {
            Files.deleteIfExists(path);
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<String> classLines = new ArrayList<String>();
        ArrayList<String> fieldLines = new ArrayList<String>();
        ArrayList<String> methodLines = new ArrayList<String>();
        Collection rootEntries = Lists.newArrayList(mappings).stream().map(EntryTreeNode::getEntry).collect(Collectors.toList());
        progress.init(rootEntries.size(), I18n.translate("progress.mappings.srg_file.generating"));
        int steps = 0;
        for (Entry<?> entry : this.sorted(rootEntries)) {
            progress.step(steps++, entry.getName());
            this.writeEntry(classLines, fieldLines, methodLines, mappings, entry);
        }
        progress.init(3, I18n.translate("progress.mappings.srg_file.writing"));
        try (LFPrintWriter writer = new LFPrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            progress.step(0, I18n.translate("type.classes"));
            classLines.forEach(writer::println);
            progress.step(1, I18n.translate("type.fields"));
            fieldLines.forEach(writer::println);
            progress.step(2, I18n.translate("type.methods"));
            methodLines.forEach(writer::println);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeEntry(List<String> classes, List<String> fields, List<String> methods, EntryTree<EntryMapping> mappings, Entry<?> entry) {
        EntryTreeNode<EntryMapping> node = mappings.findNode(entry);
        if (node == null) {
            return;
        }
        MappingTranslator translator = new MappingTranslator(mappings, VoidEntryResolver.INSTANCE);
        if (entry instanceof ClassEntry) {
            classes.add(this.generateClassLine((ClassEntry)entry, translator));
        } else if (entry instanceof FieldEntry) {
            fields.add(this.generateFieldLine((FieldEntry)entry, translator));
        } else if (entry instanceof MethodEntry) {
            methods.add(this.generateMethodLine((MethodEntry)entry, translator));
        }
        for (Entry<?> child : this.sorted(node.getChildren())) {
            this.writeEntry(classes, fields, methods, mappings, child);
        }
    }

    private String generateClassLine(ClassEntry sourceEntry, Translator translator) {
        ClassEntry targetEntry = translator.translate(sourceEntry);
        return "CL: " + sourceEntry.getFullName() + " " + targetEntry.getFullName();
    }

    private String generateMethodLine(MethodEntry sourceEntry, Translator translator) {
        MethodEntry targetEntry = translator.translate(sourceEntry);
        return "MD: " + this.describeMethod(sourceEntry) + " " + this.describeMethod(targetEntry);
    }

    private String describeMethod(MethodEntry entry) {
        return ((ClassEntry)entry.getParent()).getFullName() + "/" + entry.getName() + " " + entry.getDesc();
    }

    private String generateFieldLine(FieldEntry sourceEntry, Translator translator) {
        FieldEntry targetEntry = translator.translate(sourceEntry);
        return "FD: " + this.describeField(sourceEntry) + " " + this.describeField(targetEntry);
    }

    private String describeField(FieldEntry entry) {
        return ((ClassEntry)entry.getParent()).getFullName() + "/" + entry.getName();
    }

    private Collection<Entry<?>> sorted(Iterable<Entry<?>> iterable) {
        ArrayList sorted = Lists.newArrayList(iterable);
        sorted.sort(Comparator.comparing(Entry::getName));
        return sorted;
    }
}

