/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaTitlePane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class DarculaRootPaneUI
extends BasicRootPaneUI {
    private Cursor myLastCursor;
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window myWindow;
    private JComponent myTitlePane;
    private MouseInputListener myMouseInputListener;
    private MouseInputListener myTitleMouseInputListener;
    private LayoutManager myLayoutManager;
    private LayoutManager myOldLayout;
    protected JRootPane myRootPane;
    protected WindowListener myWindowListener;
    protected Window myCurrentWindow;
    protected HierarchyListener myHierarchyListener;
    protected ComponentListener myWindowComponentListener;
    protected GraphicsConfiguration currentRootPaneGC;
    protected PropertyChangeListener myPropertyChangeListener;
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent comp) {
        return new DarculaRootPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.myRootPane = (JRootPane)c;
        int style = this.myRootPane.getWindowDecorationStyle();
        if (style != 0) {
            this.installClientDecorations(this.myRootPane);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.myRootPane);
        this.myLayoutManager = null;
        this.myMouseInputListener = null;
        this.myRootPane = null;
    }

    public void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, "RootPane.border");
        }
    }

    private static void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this.myWindow = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.myWindow != null) {
            if (this.myMouseInputListener == null) {
                this.myMouseInputListener = this.createWindowMouseInputListener(root);
            }
            this.myWindow.addMouseListener(this.myMouseInputListener);
            this.myWindow.addMouseMotionListener(this.myMouseInputListener);
            if (this.myTitlePane != null) {
                if (this.myTitleMouseInputListener == null) {
                    this.myTitleMouseInputListener = new TitleMouseInputHandler();
                }
                this.myTitlePane.addMouseMotionListener(this.myTitleMouseInputListener);
                this.myTitlePane.addMouseListener(this.myTitleMouseInputListener);
            }
            this.setMaximized();
        }
    }

    private void uninstallWindowListeners(JRootPane root) {
        if (this.myWindow != null) {
            this.myWindow.removeMouseListener(this.myMouseInputListener);
            this.myWindow.removeMouseMotionListener(this.myMouseInputListener);
        }
        if (this.myTitlePane != null) {
            this.myTitlePane.removeMouseListener(this.myTitleMouseInputListener);
            this.myTitlePane.removeMouseMotionListener(this.myTitleMouseInputListener);
        }
    }

    private void installLayout(JRootPane root) {
        if (this.myLayoutManager == null) {
            this.myLayoutManager = this.createLayoutManager();
        }
        this.myOldLayout = root.getLayout();
        root.setLayout(this.myLayoutManager);
    }

    @Override
    protected void installListeners(final JRootPane root) {
        super.installListeners(root);
        this.myHierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Container parent = root.getParent();
                if (parent == null) {
                    return;
                }
                if (parent.getClass().getName().startsWith("org.jdesktop.jdic.tray") || parent.getClass().getName().compareTo("javax.swing.Popup$HeavyWeightWindow") == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            root.removeHierarchyListener(DarculaRootPaneUI.this.myHierarchyListener);
                            DarculaRootPaneUI.this.myHierarchyListener = null;
                        }
                    });
                }
                Window currWindow = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
                if (DarculaRootPaneUI.this.myWindowListener != null) {
                    DarculaRootPaneUI.this.myCurrentWindow.removeWindowListener(DarculaRootPaneUI.this.myWindowListener);
                    DarculaRootPaneUI.this.myWindowListener = null;
                }
                if (DarculaRootPaneUI.this.myWindowComponentListener != null) {
                    DarculaRootPaneUI.this.myCurrentWindow.removeComponentListener(DarculaRootPaneUI.this.myWindowComponentListener);
                    DarculaRootPaneUI.this.myWindowComponentListener = null;
                }
                if (currWindow != null) {
                    DarculaRootPaneUI.this.myWindowListener = new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Frame[] frames;
                                    for (Frame frame : frames = Frame.getFrames()) {
                                        if (!frame.isDisplayable()) continue;
                                        return;
                                    }
                                }
                            });
                        }
                    };
                    if (!(parent instanceof JInternalFrame)) {
                        currWindow.addWindowListener(DarculaRootPaneUI.this.myWindowListener);
                    }
                    DarculaRootPaneUI.this.myWindowComponentListener = new ComponentAdapter(){

                        @Override
                        public void componentMoved(ComponentEvent e) {
                            this.processNewPosition();
                        }

                        @Override
                        public void componentResized(ComponentEvent e) {
                            this.processNewPosition();
                        }

                        private void processNewPosition() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (DarculaRootPaneUI.this.myWindow == null) {
                                        return;
                                    }
                                    if (!DarculaRootPaneUI.this.myWindow.isShowing() || !DarculaRootPaneUI.this.myWindow.isDisplayable()) {
                                        DarculaRootPaneUI.this.currentRootPaneGC = null;
                                        return;
                                    }
                                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                                    GraphicsDevice[] gds = ge.getScreenDevices();
                                    if (gds.length == 1) {
                                        return;
                                    }
                                    Point midLoc = new Point(((DarculaRootPaneUI)DarculaRootPaneUI.this).myWindow.getLocationOnScreen().x + DarculaRootPaneUI.this.myWindow.getWidth() / 2, ((DarculaRootPaneUI)DarculaRootPaneUI.this).myWindow.getLocationOnScreen().y + DarculaRootPaneUI.this.myWindow.getHeight() / 2);
                                    for (GraphicsDevice gd : gds) {
                                        GraphicsConfiguration gc = gd.getDefaultConfiguration();
                                        Rectangle bounds = gc.getBounds();
                                        if (!bounds.contains(midLoc)) continue;
                                        if (gc == DarculaRootPaneUI.this.currentRootPaneGC) break;
                                        DarculaRootPaneUI.this.currentRootPaneGC = gc;
                                        DarculaRootPaneUI.this.setMaximized();
                                        break;
                                    }
                                }
                            });
                        }
                    };
                    if (parent instanceof JFrame) {
                        currWindow.addComponentListener(DarculaRootPaneUI.this.myWindowComponentListener);
                    }
                    DarculaRootPaneUI.this.myWindow = currWindow;
                }
                DarculaRootPaneUI.this.myCurrentWindow = currWindow;
            }
        };
        root.addHierarchyListener(this.myHierarchyListener);
        root.addPropertyChangeListener(this.myPropertyChangeListener);
    }

    @Override
    protected void uninstallListeners(JRootPane root) {
        if (this.myWindow != null) {
            this.myWindow.removeWindowListener(this.myWindowListener);
            this.myWindowListener = null;
            this.myWindow.removeComponentListener(this.myWindowComponentListener);
            this.myWindowComponentListener = null;
        }
        root.removeHierarchyListener(this.myHierarchyListener);
        this.myHierarchyListener = null;
        root.removePropertyChangeListener(this.myPropertyChangeListener);
        this.myPropertyChangeListener = null;
        super.uninstallListeners(root);
    }

    private void uninstallLayout(JRootPane root) {
        if (this.myOldLayout != null) {
            root.setLayout(this.myOldLayout);
            this.myOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        JComponent titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this.myWindow != null) {
            root.revalidate();
            root.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        DarculaRootPaneUI.uninstallBorder(root);
        this.uninstallWindowListeners(root);
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this.myWindow != null) {
            this.myWindow.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.myWindow = null;
    }

    protected JComponent createTitlePane(JRootPane root) {
        return new DarculaTitlePane(root, this);
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane root) {
        return new MouseInputHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new SubstanceRootLayout();
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.myTitlePane = titlePane;
    }

    public void setMaximized() {
        Container tla = this.myRootPane.getTopLevelAncestor();
        GraphicsConfiguration gc = this.currentRootPaneGC != null ? this.currentRootPaneGC : tla.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        screenBounds.x = 0;
        screenBounds.y = 0;
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle maxBounds = new Rectangle(screenBounds.x + screenInsets.left, screenBounds.y + screenInsets.top, screenBounds.width - (screenInsets.left + screenInsets.right), screenBounds.height - (screenInsets.top + screenInsets.bottom));
        if (tla instanceof JFrame) {
            ((JFrame)tla).setMaximizedBounds(maxBounds);
        }
    }

    public JComponent getTitlePane() {
        return this.myTitlePane;
    }

    protected JRootPane getRootPane() {
        return this.myRootPane;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e.getSource();
            int style = root.getWindowDecorationStyle();
            this.uninstallClientDecorations(root);
            if (style != 0) {
                this.installClientDecorations(root);
            }
        }
        if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners(this.myRootPane);
            if (((JRootPane)e.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.myRootPane, this.myRootPane.getParent());
            }
        }
    }

    private class TitleMouseInputHandler
    extends MouseInputAdapter {
        private Point dragOffset = new Point(0, 0);

        private TitleMouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            JRootPane rootPane = DarculaRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Component source = (Component)ev.getSource();
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(source, dragWindowOffset, DarculaRootPaneUI.this.getTitlePane());
            dragWindowOffset = SwingUtilities.convertPoint(source, dragWindowOffset, DarculaRootPaneUI.this.myWindow);
            if (DarculaRootPaneUI.this.getTitlePane() != null && DarculaRootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset) && DarculaRootPaneUI.this.myWindow != null) {
                DarculaRootPaneUI.this.myWindow.toFront();
                this.dragOffset = dragWindowOffset;
            }
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            Component source = (Component)ev.getSource();
            Point eventLocationOnScreen = ev.getLocationOnScreen();
            if (eventLocationOnScreen == null) {
                eventLocationOnScreen = new Point(ev.getX() + source.getLocationOnScreen().x, ev.getY() + source.getLocationOnScreen().y);
            }
            if (DarculaRootPaneUI.this.myWindow instanceof Frame) {
                Frame f = (Frame)DarculaRootPaneUI.this.myWindow;
                int frameState = f.getExtendedState();
                if ((frameState & 6) == 0) {
                    DarculaRootPaneUI.this.myWindow.setLocation(eventLocationOnScreen.x - this.dragOffset.x, eventLocationOnScreen.y - this.dragOffset.y);
                }
            } else {
                DarculaRootPaneUI.this.myWindow.setLocation(eventLocationOnScreen.x - this.dragOffset.x, eventLocationOnScreen.y - this.dragOffset.y);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!(DarculaRootPaneUI.this.myWindow instanceof Frame)) {
                return;
            }
            Frame f = (Frame)DarculaRootPaneUI.this.myWindow;
            Point convertedPoint = SwingUtilities.convertPoint(DarculaRootPaneUI.this.myWindow, e.getPoint(), DarculaRootPaneUI.this.getTitlePane());
            int state = f.getExtendedState();
            if (DarculaRootPaneUI.this.getTitlePane() != null && DarculaRootPaneUI.this.getTitlePane().contains(convertedPoint) && e.getClickCount() % 2 == 0 && (e.getModifiers() & 0x10) != 0 && f.isResizable()) {
                if ((state & 6) != 0) {
                    DarculaRootPaneUI.this.setMaximized();
                    f.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    DarculaRootPaneUI.this.setMaximized();
                    f.setExtendedState(state | 6);
                }
            }
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;
        private final PrivilegedExceptionAction getLocationAction = new PrivilegedExceptionAction(){

            public Object run() throws HeadlessException {
                return MouseInfo.getPointerInfo().getLocation();
            }
        };
        private CursorState cursorState = CursorState.NIL;

        private MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            int frameState;
            JRootPane rootPane = DarculaRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Window w = (Window)ev.getSource();
            if (w != null) {
                w.toFront();
            }
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, DarculaRootPaneUI.this.getTitlePane());
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int n = frameState = f != null ? f.getExtendedState() : 0;
            if (DarculaRootPaneUI.this.getTitlePane() != null && DarculaRootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset)) {
                if ((f != null && (frameState & 6) == 0 || d != null) && dragWindowOffset.y >= 5 && dragWindowOffset.x >= 5 && dragWindowOffset.x < w.getWidth() - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                }
            } else if (f != null && f.isResizable() && (frameState & 6) == 0 || d != null && d.isResizable()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w.getWidth();
                this.dragHeight = w.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (this.dragCursor != 0 && DarculaRootPaneUI.this.myWindow != null && !DarculaRootPaneUI.this.myWindow.isValid()) {
                DarculaRootPaneUI.this.myWindow.validate();
                DarculaRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            JRootPane root = DarculaRootPaneUI.this.getRootPane();
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = (Window)ev.getSource();
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int cursor = this.getCursor(this.calculateCorner(w, ev.getX(), ev.getY()));
            if (cursor != 0 && (f != null && f.isResizable() && (f.getExtendedState() & 6) == 0 || d != null && d.isResizable())) {
                w.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                w.setCursor(DarculaRootPaneUI.this.myLastCursor);
            }
        }

        private void adjust(Rectangle bounds, Dimension min2, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min2 != null) {
                int correction;
                if (bounds.width < min2.width) {
                    correction = min2.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min2.width;
                }
                if (bounds.height < min2.height) {
                    correction = min2.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min2.height;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Point pt = ev.getPoint();
            if (this.isMovingWindow) {
                try {
                    Point windowPt = (Point)AccessController.doPrivileged(this.getLocationAction);
                    windowPt.x -= this.dragOffsetX;
                    windowPt.y -= this.dragOffsetY;
                    w.setLocation(windowPt);
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else if (this.dragCursor != 0) {
                Rectangle r = w.getBounds();
                Rectangle startBounds = new Rectangle(r);
                Dimension min2 = w.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(r, min2, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(r, min2, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 8: {
                        this.adjust(r, min2, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(r, min2, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(r, min2, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(r, min2, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 6: {
                        this.adjust(r, min2, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(r, min2, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                }
                if (!r.equals(startBounds)) {
                    w.setBounds(r);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        w.validate();
                        DarculaRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            if (this.cursorState == CursorState.EXITED || this.cursorState == CursorState.NIL) {
                DarculaRootPaneUI.this.myLastCursor = w.getCursor();
            }
            this.cursorState = CursorState.ENTERED;
            this.mouseMoved(ev);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            w.setCursor(DarculaRootPaneUI.this.myLastCursor);
            this.cursorState = CursorState.EXITED;
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            if (!(w instanceof Frame)) {
                return;
            }
            Frame f = (Frame)w;
            JComponent windowTitlePane = DarculaRootPaneUI.this.getTitlePane();
            if (windowTitlePane == null) {
                return;
            }
            Point convertedPoint = SwingUtilities.convertPoint(w, ev.getPoint(), windowTitlePane);
            int state = f.getExtendedState();
            if (windowTitlePane.contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && f.isResizable()) {
                if ((state & 6) != 0) {
                    DarculaRootPaneUI.this.setMaximized();
                    f.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    DarculaRootPaneUI.this.setMaximized();
                    f.setExtendedState(state | 6);
                }
            }
        }

        private int calculateCorner(Window w, int x, int y) {
            Insets insets = w.getInsets();
            int xPosition = this.calculatePosition(x - insets.left, w.getWidth() - insets.left - insets.right);
            int yPosition = this.calculatePosition(y - insets.top, w.getHeight() - insets.top - insets.bottom);
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return cursorMapping[corner];
        }

        private int calculatePosition(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }

    protected class SubstanceRootLayout
    implements LayoutManager2 {
        protected SubstanceRootLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof DarculaRootPaneUI && (titlePane = ((DarculaRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            int tpHeight = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof DarculaRootPaneUI && (titlePane = ((DarculaRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpHeight + i.top + i.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof DarculaRootPaneUI && (titlePane = ((DarculaRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i.left + i.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int w = b.width - i.right - i.left;
            int h2 = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h2);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h2);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof DarculaRootPaneUI && (titlePane = ((DarculaRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w, h2 < nextY ? 0 : h2 - nextY);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }

    private static enum CursorState {
        EXITED,
        ENTERED,
        NIL;

    }
}

