/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.io.MoreFiles;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConverter;

public class Main {
    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<Path> jar = parser.accepts("jar", "Jar file to open at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec<Path> mappings = parser.accepts("mappings", "Mappings file to open at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        ArgumentAcceptingOptionSpec<Path> profile = parser.accepts("profile", "Profile json to apply at startup").withRequiredArg().withValuesConvertedBy(PathConverter.INSTANCE);
        parser.accepts("help", "Displays help information");
        try {
            EnigmaProfile parsedProfile;
            Object reader;
            OptionSet options = parser.parse(args);
            if (options.has("help")) {
                parser.printHelpOn(System.out);
                return;
            }
            if (options.has(profile)) {
                Path profilePath = options.valueOf(profile);
                reader = Files.newBufferedReader(profilePath);
                Throwable throwable = null;
                try {
                    parsedProfile = EnigmaProfile.parse((Reader)reader);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                ((BufferedReader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((BufferedReader)reader).close();
                        }
                    }
                }
            }
            try {
                BufferedReader reader2 = new BufferedReader(new InputStreamReader(Main.class.getResourceAsStream("/profile.json"), StandardCharsets.UTF_8));
                reader = null;
                try {
                    parsedProfile = EnigmaProfile.parse(reader2);
                }
                catch (Throwable throwable) {
                    reader = throwable;
                    throw throwable;
                }
                finally {
                    if (reader2 != null) {
                        if (reader != null) {
                            try {
                                reader2.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)reader).addSuppressed(throwable);
                            }
                        } else {
                            reader2.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                System.out.println("Failed to load default profile, will use empty profile: " + ex.getMessage());
                parsedProfile = EnigmaProfile.EMPTY;
            }
            Gui gui = new Gui(parsedProfile);
            GuiController controller = gui.getController();
            if (options.has(jar)) {
                Path jarPath = options.valueOf(jar);
                controller.openJar(jarPath).whenComplete((v, t) -> {
                    if (options.has(mappings)) {
                        Path mappingsPath = (Path)options.valueOf(mappings);
                        if (Files.isDirectory(mappingsPath, new LinkOption[0])) {
                            controller.openMappings(MappingFormat.ENIGMA_DIRECTORY, mappingsPath);
                        } else if ("zip".equalsIgnoreCase(MoreFiles.getFileExtension(mappingsPath))) {
                            controller.openMappings(MappingFormat.ENIGMA_ZIP, mappingsPath);
                        } else {
                            controller.openMappings(MappingFormat.ENIGMA_FILE, mappingsPath);
                        }
                    }
                });
            }
        }
        catch (OptionException e) {
            System.out.println("Invalid arguments: " + e.getMessage());
            System.out.println();
            parser.printHelpOn(System.out);
        }
    }

    private static class PathConverter
    implements ValueConverter<Path> {
        static final ValueConverter<Path> INSTANCE = new PathConverter();

        PathConverter() {
        }

        @Override
        public Path convert(String path) {
            if (path.startsWith("~")) {
                Path dirHome = Paths.get(System.getProperty("user.home"), new String[0]);
                if (path.startsWith("~/")) {
                    return dirHome.resolve(path.substring(2));
                }
                return dirHome.getParent().resolve(path.substring(1));
            }
            return Paths.get(path, new String[0]);
        }

        @Override
        public Class<? extends Path> valueType() {
            return Path.class;
        }

        @Override
        public String valuePattern() {
            return "path";
        }
    }
}

