/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.api.EnigmaPlugin;
import cuchaz.enigma.api.EnigmaPluginContext;
import cuchaz.enigma.api.service.JarIndexerService;
import cuchaz.enigma.api.service.NameProposalService;
import cuchaz.enigma.source.DecompilerService;
import cuchaz.enigma.source.Decompilers;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

public final class BuiltinPlugin
implements EnigmaPlugin {
    @Override
    public void init(EnigmaPluginContext ctx) {
        this.registerEnumNamingService(ctx);
        this.registerDecompilerServices(ctx);
    }

    private void registerEnumNamingService(EnigmaPluginContext ctx) {
        HashMap names = new HashMap();
        EnumFieldNameFindingVisitor visitor = new EnumFieldNameFindingVisitor(names);
        ctx.registerService("enigma:enum_initializer_indexer", JarIndexerService.TYPE, ctx1 -> (classCache, jarIndex) -> classCache.visit(() -> visitor, 4));
        ctx.registerService("enigma:enum_name_proposer", NameProposalService.TYPE, ctx1 -> (obfEntry, remapper) -> Optional.ofNullable(names.get(obfEntry)));
    }

    private void registerDecompilerServices(EnigmaPluginContext ctx) {
        ctx.registerService("enigma:procyon", DecompilerService.TYPE, ctx1 -> Decompilers.PROCYON);
        ctx.registerService("enigma:cfr", DecompilerService.TYPE, ctx1 -> Decompilers.CFR);
    }

    private static final class EnumFieldNameFindingVisitor
    extends ClassVisitor {
        private ClassEntry clazz;
        private String className;
        private final Map<Entry<?>, String> mappings;
        private final Set<Pair<String, String>> enumFields = new HashSet<Pair<String, String>>();
        private final List<MethodNode> classInits = new ArrayList<MethodNode>();

        EnumFieldNameFindingVisitor(Map<Entry<?>, String> mappings) {
            super(524288);
            this.mappings = mappings;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            this.clazz = new ClassEntry(name);
            this.enumFields.clear();
            this.classInits.clear();
        }

        @Override
        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if ((access & 0x4000) != 0 && !this.enumFields.add(new Pair<String, String>(name, descriptor))) {
                throw new IllegalArgumentException("Found two enum fields with the same name \"" + name + "\" and desc \"" + descriptor + "\"!");
            }
            return super.visitField(access, name, descriptor, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if ("<clinit>".equals(name)) {
                MethodNode node = new MethodNode(this.api, access, name, descriptor, signature, exceptions);
                this.classInits.add(node);
                return node;
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            try {
                this.collectResults();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private void collectResults() throws Exception {
            String owner = this.className;
            Analyzer<SourceValue> analyzer = new Analyzer<SourceValue>(new SourceInterpreter());
            for (MethodNode mn : this.classInits) {
                Frame<SourceValue>[] frames = analyzer.analyze(this.className, mn);
                InsnList instrs = mn.instructions;
                for (int i = 1; i < instrs.size(); ++i) {
                    AbstractInsnNode instr1 = instrs.get(i - 1);
                    AbstractInsnNode instr2 = instrs.get(i);
                    String s2 = null;
                    if (instr2.getOpcode() == 179 && ((FieldInsnNode)instr2).owner.equals(owner) && this.enumFields.contains(new Pair<String, String>(((FieldInsnNode)instr2).name, ((FieldInsnNode)instr2).desc)) && instr1.getOpcode() == 183 && "<init>".equals(((MethodInsnNode)instr1).name)) {
                        for (int j = 0; j < frames[i - 1].getStackSize(); ++j) {
                            SourceValue sv = frames[i - 1].getStack(j);
                            for (AbstractInsnNode ci : sv.insns) {
                                if (!(ci instanceof LdcInsnNode) || !(((LdcInsnNode)ci).cst instanceof String) || s2 != null) continue;
                                s2 = (String)((LdcInsnNode)ci).cst;
                            }
                        }
                    }
                    if (s2 == null) continue;
                    this.mappings.put(new FieldEntry(this.clazz, ((FieldInsnNode)instr2).name, new TypeDescriptor(((FieldInsnNode)instr2).desc)), s2);
                }
            }
        }
    }
}

