/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.ExceptionIgnorer;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.ClassReferenceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.FieldReferenceTreeNode;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.MethodReferenceTreeNode;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.config.Config;
import cuchaz.enigma.config.Themes;
import cuchaz.enigma.gui.ClassSelector;
import cuchaz.enigma.gui.CodeReader;
import cuchaz.enigma.gui.DecompiledClassSource;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.MethodTreeCellRenderer;
import cuchaz.enigma.gui.TokenListCellRenderer;
import cuchaz.enigma.gui.dialog.CrashDialog;
import cuchaz.enigma.gui.dialog.JavadocDialog;
import cuchaz.enigma.gui.elements.MenuBar;
import cuchaz.enigma.gui.elements.PopupMenuBar;
import cuchaz.enigma.gui.filechooser.FileChooserAny;
import cuchaz.enigma.gui.filechooser.FileChooserFolder;
import cuchaz.enigma.gui.highlight.BoxHighlightPainter;
import cuchaz.enigma.gui.highlight.SelectionHighlightPainter;
import cuchaz.enigma.gui.highlight.TokenHighlightType;
import cuchaz.enigma.gui.panels.PanelDeobf;
import cuchaz.enigma.gui.panels.PanelEditor;
import cuchaz.enigma.gui.panels.PanelIdentifier;
import cuchaz.enigma.gui.panels.PanelObf;
import cuchaz.enigma.gui.util.History;
import cuchaz.enigma.throwables.IllegalNameException;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.Utils;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Gui {
    public final PopupMenuBar popupMenu;
    private final PanelObf obfPanel;
    private final PanelDeobf deobfPanel;
    private final MenuBar menuBar;
    public History<EntryReference<Entry<?>, Entry<?>>> referenceHistory;
    public EntryReference<Entry<?>, Entry<?>> cursorReference;
    private boolean shouldNavigateOnClick;
    public FileDialog jarFileChooser;
    public FileDialog tinyMappingsFileChooser;
    public JFileChooser enigmaMappingsFileChooser;
    public JFileChooser exportSourceFileChooser;
    public FileDialog exportJarFileChooser;
    private GuiController controller;
    private JFrame frame;
    public Config.LookAndFeel editorFeel;
    public PanelEditor editor;
    private JPanel classesPanel;
    private JSplitPane splitClasses;
    private PanelIdentifier infoPanel;
    public Map<TokenHighlightType, BoxHighlightPainter> boxHighlightPainters;
    private SelectionHighlightPainter selectionHighlightPainter;
    private JTree inheritanceTree;
    private JTree implementationsTree;
    private JTree callsTree;
    private JList<Token> tokens;
    private JTabbedPane tabs;
    public JTextField renameTextField;
    public JTextArea javadocTextArea;

    public void setEditorTheme(Config.LookAndFeel feel) {
        if (this.editor != null && (this.editorFeel == null || this.editorFeel != feel)) {
            this.editor.updateUI();
            this.editor.setBackground(new Color(Config.getInstance().editorBackground));
            if (this.editorFeel != null) {
                this.getController().refreshCurrentClass();
            }
            this.editorFeel = feel;
        }
    }

    public Gui(EnigmaProfile profile) {
        Config.getInstance().lookAndFeel.setGlobalLAF();
        this.frame = new JFrame("Enigma");
        Container pane = this.frame.getContentPane();
        pane.setLayout(new BorderLayout());
        if (Boolean.parseBoolean(System.getProperty("enigma.catchExceptions", "true"))) {
            CrashDialog.init(this.frame);
            Thread.setDefaultUncaughtExceptionHandler((thread, t) -> {
                t.printStackTrace(System.err);
                if (!ExceptionIgnorer.shouldIgnore(t)) {
                    CrashDialog.show(t);
                }
            });
        }
        this.controller = new GuiController(this, profile);
        this.jarFileChooser = new FileDialog((Frame)this.getFrame(), I18n.translate("menu.file.jar.open"), 0);
        this.tinyMappingsFileChooser = new FileDialog((Frame)this.getFrame(), "Open tiny Mappings", 0);
        this.enigmaMappingsFileChooser = new FileChooserAny();
        this.exportSourceFileChooser = new FileChooserFolder();
        this.exportJarFileChooser = new FileDialog((Frame)this.getFrame(), I18n.translate("menu.file.export.jar"), 1);
        this.obfPanel = new PanelObf(this);
        this.deobfPanel = new PanelDeobf(this);
        this.splitClasses = new JSplitPane(0, true, this.obfPanel, this.deobfPanel);
        this.splitClasses.setResizeWeight(0.3);
        this.classesPanel = new JPanel();
        this.classesPanel.setLayout(new BorderLayout());
        this.classesPanel.setPreferredSize(new Dimension(250, 0));
        this.infoPanel = new PanelIdentifier(this);
        this.infoPanel.clearReference();
        Themes.updateTheme(this);
        this.selectionHighlightPainter = new SelectionHighlightPainter();
        this.editor = new PanelEditor(this);
        JScrollPane sourceScroller = new JScrollPane(this.editor);
        this.editor.setContentType("text/enigma-sources");
        this.editor.setBackground(new Color(Config.getInstance().editorBackground));
        DefaultSyntaxKit kit = (DefaultSyntaxKit)this.editor.getEditorKit();
        kit.toggleComponent(this.editor, "de.sciss.syntaxpane.components.TokenMarker");
        this.popupMenu = new PopupMenuBar(this);
        this.editor.setComponentPopupMenu(this.popupMenu);
        this.inheritanceTree = new JTree();
        this.inheritanceTree.setModel(null);
        this.inheritanceTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() >= 2) {
                    MethodInheritanceTreeNode methodNode;
                    TreePath path = Gui.this.inheritanceTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ClassInheritanceTreeNode) {
                        ClassInheritanceTreeNode classNode = (ClassInheritanceTreeNode)node;
                        Gui.this.controller.navigateTo(new ClassEntry(classNode.getObfClassName()));
                    } else if (node instanceof MethodInheritanceTreeNode && (methodNode = (MethodInheritanceTreeNode)node).isImplemented()) {
                        Gui.this.controller.navigateTo(methodNode.getMethodEntry());
                    }
                }
            }
        });
        TreeCellRenderer cellRenderer = this.inheritanceTree.getCellRenderer();
        this.inheritanceTree.setCellRenderer(new MethodTreeCellRenderer(cellRenderer));
        JPanel inheritancePanel = new JPanel();
        inheritancePanel.setLayout(new BorderLayout());
        inheritancePanel.add(new JScrollPane(this.inheritanceTree));
        this.implementationsTree = new JTree();
        this.implementationsTree.setModel(null);
        this.implementationsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() >= 2) {
                    TreePath path = Gui.this.implementationsTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ClassImplementationsTreeNode) {
                        ClassImplementationsTreeNode classNode = (ClassImplementationsTreeNode)node;
                        Gui.this.controller.navigateTo(classNode.getClassEntry());
                    } else if (node instanceof MethodImplementationsTreeNode) {
                        MethodImplementationsTreeNode methodNode = (MethodImplementationsTreeNode)node;
                        Gui.this.controller.navigateTo(methodNode.getMethodEntry());
                    }
                }
            }
        });
        JPanel implementationsPanel = new JPanel();
        implementationsPanel.setLayout(new BorderLayout());
        implementationsPanel.add(new JScrollPane(this.implementationsTree));
        this.callsTree = new JTree();
        this.callsTree.setModel(null);
        this.callsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() >= 2) {
                    TreePath path = Gui.this.callsTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ReferenceTreeNode) {
                        ReferenceTreeNode referenceNode = (ReferenceTreeNode)node;
                        if (referenceNode.getReference() != null) {
                            Gui.this.controller.navigateTo(referenceNode.getReference());
                        } else {
                            Gui.this.controller.navigateTo((Entry<?>)referenceNode.getEntry());
                        }
                    }
                }
            }
        });
        this.tokens = new JList();
        this.tokens.setCellRenderer(new TokenListCellRenderer(this.controller));
        this.tokens.setSelectionMode(0);
        this.tokens.setLayoutOrientation(0);
        this.tokens.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Token selected;
                if (event.getClickCount() == 2 && (selected = (Token)Gui.this.tokens.getSelectedValue()) != null) {
                    Gui.this.showToken(selected);
                }
            }
        });
        this.tokens.setPreferredSize(new Dimension(0, 200));
        this.tokens.setMinimumSize(new Dimension(0, 200));
        JSplitPane callPanel = new JSplitPane(0, true, new JScrollPane(this.callsTree), new JScrollPane(this.tokens));
        callPanel.setResizeWeight(1.0);
        callPanel.resetToPreferredSizes();
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.infoPanel, "North");
        centerPanel.add((Component)sourceScroller, "Center");
        this.tabs = new JTabbedPane();
        this.tabs.setPreferredSize(new Dimension(250, 0));
        this.tabs.addTab(I18n.translate("info_panel.tree.inheritance"), inheritancePanel);
        this.tabs.addTab(I18n.translate("info_panel.tree.implementations"), implementationsPanel);
        this.tabs.addTab(I18n.translate("info_panel.tree.calls"), callPanel);
        JSplitPane splitRight = new JSplitPane(1, true, centerPanel, this.tabs);
        splitRight.setResizeWeight(1.0);
        splitRight.resetToPreferredSizes();
        JSplitPane splitCenter = new JSplitPane(1, true, this.classesPanel, splitRight);
        splitCenter.setResizeWeight(0.0);
        pane.add((Component)splitCenter, "Center");
        this.menuBar = new MenuBar(this);
        this.frame.setJMenuBar(this.menuBar);
        this.onCloseJar();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Gui.this.close();
            }
        });
        pane.doLayout();
        this.frame.setSize(1024, 576);
        this.frame.setMinimumSize(new Dimension(640, 480));
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(0);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public GuiController getController() {
        return this.controller;
    }

    public void onStartOpenJar() {
        this.classesPanel.removeAll();
        this.redraw();
    }

    public void onFinishOpenJar(String jarName) {
        this.frame.setTitle("Enigma - " + jarName);
        this.classesPanel.removeAll();
        this.classesPanel.add(this.splitClasses);
        this.setEditorText(null);
        this.menuBar.closeJarMenu.setEnabled(true);
        this.menuBar.openMappingsMenus.forEach(item -> item.setEnabled(true));
        this.menuBar.saveMappingsMenu.setEnabled(false);
        this.menuBar.saveMappingsMenus.forEach(item -> item.setEnabled(true));
        this.menuBar.closeMappingsMenu.setEnabled(true);
        this.menuBar.exportSourceMenu.setEnabled(true);
        this.menuBar.exportJarMenu.setEnabled(true);
        this.redraw();
    }

    public void onCloseJar() {
        this.frame.setTitle("Enigma");
        this.setObfClasses(null);
        this.setDeobfClasses(null);
        this.setEditorText(null);
        this.classesPanel.removeAll();
        this.menuBar.closeJarMenu.setEnabled(false);
        this.menuBar.openMappingsMenus.forEach(item -> item.setEnabled(false));
        this.menuBar.saveMappingsMenu.setEnabled(false);
        this.menuBar.saveMappingsMenus.forEach(item -> item.setEnabled(false));
        this.menuBar.closeMappingsMenu.setEnabled(false);
        this.menuBar.exportSourceMenu.setEnabled(false);
        this.menuBar.exportJarMenu.setEnabled(false);
        this.redraw();
    }

    public void setObfClasses(Collection<ClassEntry> obfClasses) {
        this.obfPanel.obfClasses.setClasses(obfClasses);
    }

    public void setDeobfClasses(Collection<ClassEntry> deobfClasses) {
        this.deobfPanel.deobfClasses.setClasses(deobfClasses);
    }

    public void setMappingsFile(Path path) {
        this.enigmaMappingsFileChooser.setSelectedFile(path != null ? path.toFile() : null);
        this.menuBar.saveMappingsMenu.setEnabled(path != null);
    }

    public void setEditorText(String source) {
        this.editor.getHighlighter().removeAllHighlights();
        this.editor.setText(source);
    }

    public void setSource(DecompiledClassSource source) {
        this.editor.setText(source.toString());
        this.setHighlightedTokens(source.getHighlightedTokens());
    }

    public void showToken(Token token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null!");
        }
        CodeReader.navigateToToken(this.editor, token, this.selectionHighlightPainter);
        this.redraw();
    }

    public void showTokens(Collection<Token> tokens) {
        Vector<Token> sortedTokens = new Vector<Token>(tokens);
        Collections.sort(sortedTokens);
        if (sortedTokens.size() > 1) {
            this.tokens.setListData(sortedTokens);
            this.tokens.setSelectedIndex(0);
        } else {
            this.tokens.setListData(new Vector());
        }
        this.showToken(sortedTokens.get(0));
    }

    public void setHighlightedTokens(Map<TokenHighlightType, Collection<Token>> tokens) {
        this.editor.getHighlighter().removeAllHighlights();
        if (this.boxHighlightPainters != null) {
            for (TokenHighlightType type : tokens.keySet()) {
                BoxHighlightPainter painter = this.boxHighlightPainters.get((Object)type);
                if (painter == null) continue;
                this.setHighlightedTokens((Iterable<Token>)tokens.get((Object)type), painter);
            }
        }
        this.redraw();
    }

    private void setHighlightedTokens(Iterable<Token> tokens, Highlighter.HighlightPainter painter) {
        for (Token token : tokens) {
            try {
                this.editor.getHighlighter().addHighlight(token.start, token.end, painter);
            }
            catch (BadLocationException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private void showCursorReference(EntryReference<Entry<?>, Entry<?>> reference) {
        if (reference == null) {
            this.infoPanel.clearReference();
            return;
        }
        this.cursorReference = reference;
        EntryReference<Entry<?>, Entry<?>> translatedReference = this.controller.project.getMapper().deobfuscate(reference);
        this.infoPanel.removeAll();
        if (translatedReference.entry instanceof ClassEntry) {
            this.showClassEntry((ClassEntry)translatedReference.entry);
        } else if (translatedReference.entry instanceof FieldEntry) {
            this.showFieldEntry((FieldEntry)translatedReference.entry);
        } else if (translatedReference.entry instanceof MethodEntry) {
            this.showMethodEntry((MethodEntry)translatedReference.entry);
        } else if (translatedReference.entry instanceof LocalVariableEntry) {
            this.showLocalVariableEntry((LocalVariableEntry)translatedReference.entry);
        } else {
            throw new Error("Unknown entry desc: " + translatedReference.entry.getClass().getName());
        }
        this.redraw();
    }

    private void showLocalVariableEntry(LocalVariableEntry entry) {
        this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.variable"), entry.getName());
        this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.class"), entry.getContainingClass().getFullName());
        this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.method"), ((MethodEntry)entry.getParent()).getName());
        this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.index"), Integer.toString(entry.getIndex()));
    }

    private void showClassEntry(ClassEntry entry) {
        this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.class"), entry.getFullName());
        this.addModifierComboBox(this.infoPanel, I18n.translate("info_panel.identifier.modifier"), entry);
    }

    private void showFieldEntry(FieldEntry entry) {
        this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.field"), entry.getName());
        this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.class"), ((ClassEntry)entry.getParent()).getFullName());
        this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.type_descriptor"), entry.getDesc().toString());
        this.addModifierComboBox(this.infoPanel, I18n.translate("info_panel.identifier.modifier"), entry);
    }

    private void showMethodEntry(MethodEntry entry) {
        if (entry.isConstructor()) {
            this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.constructor"), ((ClassEntry)entry.getParent()).getFullName());
        } else {
            this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.method"), entry.getName());
            this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.class"), ((ClassEntry)entry.getParent()).getFullName());
        }
        this.addNameValue(this.infoPanel, I18n.translate("info_panel.identifier.method_descriptor"), entry.getDesc().toString());
        this.addModifierComboBox(this.infoPanel, I18n.translate("info_panel.identifier.modifier"), entry);
    }

    private void addNameValue(JPanel container, String name, String value) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 6, 0));
        JLabel label = new JLabel(name + ":", 4);
        label.setPreferredSize(new Dimension(100, label.getPreferredSize().height));
        panel.add(label);
        panel.add(Utils.unboldLabel(new JLabel(value, 2)));
        container.add(panel);
    }

    private JComboBox<AccessModifier> addModifierComboBox(JPanel container, String name, Entry<?> entry) {
        if (!this.getController().project.isRenamable(entry)) {
            return null;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 6, 0));
        JLabel label = new JLabel(name + ":", 4);
        label.setPreferredSize(new Dimension(100, label.getPreferredSize().height));
        panel.add(label);
        JComboBox<AccessModifier> combo = new JComboBox<AccessModifier>(AccessModifier.values());
        ((JLabel)((Object)combo.getRenderer())).setHorizontalAlignment(2);
        combo.setPreferredSize(new Dimension(100, label.getPreferredSize().height));
        EntryMapping mapping = this.controller.project.getMapper().getDeobfMapping(entry);
        if (mapping != null) {
            combo.setSelectedIndex(mapping.getAccessModifier().ordinal());
        } else {
            combo.setSelectedIndex(AccessModifier.UNCHANGED.ordinal());
        }
        combo.addItemListener(this.controller::modifierChange);
        panel.add(combo);
        container.add(panel);
        return combo;
    }

    public void onCaretMove(int pos, boolean fromClick) {
        boolean isRenamable;
        Translatable referenceEntry;
        if (this.controller.project == null) {
            return;
        }
        EntryRemapper mapper = this.controller.project.getMapper();
        Token token = this.controller.getToken(pos);
        boolean isToken = token != null;
        this.cursorReference = this.controller.getReference(token);
        Translatable t = referenceEntry = this.cursorReference != null ? (Translatable)this.cursorReference.entry : null;
        if (referenceEntry != null && this.shouldNavigateOnClick && fromClick) {
            this.shouldNavigateOnClick = false;
            Translatable navigationEntry = referenceEntry;
            if (this.cursorReference.context == null) {
                EntryResolver resolver = mapper.getObfResolver();
                navigationEntry = resolver.resolveFirstEntry(referenceEntry, ResolutionStrategy.RESOLVE_ROOT);
            }
            this.controller.navigateTo((Entry<?>)navigationEntry);
            return;
        }
        boolean isClassEntry = isToken && referenceEntry instanceof ClassEntry;
        boolean isFieldEntry = isToken && referenceEntry instanceof FieldEntry;
        boolean isMethodEntry = isToken && referenceEntry instanceof MethodEntry && !((MethodEntry)referenceEntry).isConstructor();
        boolean isConstructorEntry = isToken && referenceEntry instanceof MethodEntry && ((MethodEntry)referenceEntry).isConstructor();
        boolean bl = isRenamable = isToken && this.controller.project.isRenamable(this.cursorReference);
        if (isToken) {
            this.showCursorReference(this.cursorReference);
        } else {
            this.infoPanel.clearReference();
        }
        this.popupMenu.renameMenu.setEnabled(isRenamable);
        this.popupMenu.editJavadocMenu.setEnabled(isRenamable);
        this.popupMenu.showInheritanceMenu.setEnabled(isClassEntry || isMethodEntry || isConstructorEntry);
        this.popupMenu.showImplementationsMenu.setEnabled(isClassEntry || isMethodEntry);
        this.popupMenu.showCallsMenu.setEnabled(isClassEntry || isFieldEntry || isMethodEntry || isConstructorEntry);
        this.popupMenu.showCallsSpecificMenu.setEnabled(isMethodEntry);
        this.popupMenu.openEntryMenu.setEnabled(isRenamable && (isClassEntry || isFieldEntry || isMethodEntry || isConstructorEntry));
        this.popupMenu.openPreviousMenu.setEnabled(this.controller.hasPreviousReference());
        this.popupMenu.openNextMenu.setEnabled(this.controller.hasNextReference());
        this.popupMenu.toggleMappingMenu.setEnabled(isRenamable);
        if (isToken && !Objects.equals(referenceEntry, mapper.deobfuscate(referenceEntry))) {
            this.popupMenu.toggleMappingMenu.setText(I18n.translate("popup_menu.reset_obfuscated"));
        } else {
            this.popupMenu.toggleMappingMenu.setText(I18n.translate("popup_menu.mark_deobfuscated"));
        }
    }

    public void startDocChange() {
        this.javadocTextArea = new JTextArea(10, 40);
        EntryReference<Entry<?>, Entry<?>> translatedReference = this.controller.project.getMapper().deobfuscate(this.cursorReference);
        this.javadocTextArea.setText(Strings.nullToEmpty(translatedReference.entry.getJavadocs()));
        JavadocDialog.init(this.frame, this.javadocTextArea, this::finishDocChange);
        this.javadocTextArea.grabFocus();
        this.redraw();
    }

    private void finishDocChange(JFrame ui, boolean saveName) {
        String newName = this.javadocTextArea.getText();
        if (saveName) {
            try {
                this.controller.changeDocs(this.cursorReference, newName);
            }
            catch (IllegalNameException ex) {
                this.javadocTextArea.setBorder(BorderFactory.createLineBorder(Color.red, 1));
                this.javadocTextArea.setToolTipText(ex.getReason());
                Utils.showToolTipNow(this.javadocTextArea);
                return;
            }
            ui.setVisible(false);
            this.showCursorReference(this.cursorReference);
            return;
        }
        this.javadocTextArea = null;
        ui.setVisible(false);
        this.showCursorReference(this.cursorReference);
        this.editor.grabFocus();
        this.redraw();
    }

    public void startRename() {
        this.renameTextField = new JTextField();
        EntryReference<Entry<?>, Entry<?>> translatedReference = this.controller.project.getMapper().deobfuscate(this.cursorReference);
        this.renameTextField.setText(translatedReference.getNameableName());
        this.renameTextField.setPreferredSize(new Dimension(360, this.renameTextField.getPreferredSize().height));
        this.renameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 10: {
                        Gui.this.finishRename(true);
                        break;
                    }
                    case 27: {
                        Gui.this.finishRename(false);
                        break;
                    }
                }
            }
        });
        JPanel panel = (JPanel)this.infoPanel.getComponent(0);
        panel.remove(panel.getComponentCount() - 1);
        panel.add(this.renameTextField);
        this.renameTextField.grabFocus();
        int offset = this.renameTextField.getText().lastIndexOf(47) + 1;
        if (translatedReference.getNameableEntry() instanceof ClassEntry && this.renameTextField.getText().contains("/") && offset != 0) {
            this.renameTextField.select(offset, this.renameTextField.getText().length());
        } else {
            this.renameTextField.selectAll();
        }
        this.redraw();
    }

    private void finishRename(boolean saveName) {
        String newName = this.renameTextField.getText();
        if (saveName && newName != null && !newName.isEmpty()) {
            try {
                this.controller.rename(this.cursorReference, newName, true);
            }
            catch (IllegalNameException ex) {
                this.renameTextField.setBorder(BorderFactory.createLineBorder(Color.red, 1));
                this.renameTextField.setToolTipText(ex.getReason());
                Utils.showToolTipNow(this.renameTextField);
            }
            return;
        }
        JPanel panel = (JPanel)this.infoPanel.getComponent(0);
        panel.remove(panel.getComponentCount() - 1);
        panel.add(Utils.unboldLabel(new JLabel(this.cursorReference.getNameableName(), 2)));
        this.renameTextField = null;
        this.editor.grabFocus();
        this.redraw();
    }

    public void showInheritance() {
        if (this.cursorReference == null) {
            return;
        }
        this.inheritanceTree.setModel(null);
        if (this.cursorReference.entry instanceof ClassEntry) {
            ClassInheritanceTreeNode classNode = this.controller.getClassInheritance((ClassEntry)this.cursorReference.entry);
            TreePath path = this.getPathToRoot(classNode);
            this.inheritanceTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.inheritanceTree.expandPath(path);
            this.inheritanceTree.setSelectionRow(this.inheritanceTree.getRowForPath(path));
        } else if (this.cursorReference.entry instanceof MethodEntry) {
            MethodInheritanceTreeNode classNode = this.controller.getMethodInheritance((MethodEntry)this.cursorReference.entry);
            TreePath path = this.getPathToRoot(classNode);
            this.inheritanceTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.inheritanceTree.expandPath(path);
            this.inheritanceTree.setSelectionRow(this.inheritanceTree.getRowForPath(path));
        }
        this.tabs.setSelectedIndex(0);
        this.redraw();
    }

    public void showImplementations() {
        if (this.cursorReference == null) {
            return;
        }
        this.implementationsTree.setModel(null);
        DefaultMutableTreeNode node = null;
        if (this.cursorReference.entry instanceof ClassEntry) {
            node = this.controller.getClassImplementations((ClassEntry)this.cursorReference.entry);
        } else if (this.cursorReference.entry instanceof MethodEntry) {
            node = this.controller.getMethodImplementations((MethodEntry)this.cursorReference.entry);
        }
        if (node != null) {
            TreePath path = this.getPathToRoot(node);
            this.implementationsTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.implementationsTree.expandPath(path);
            this.implementationsTree.setSelectionRow(this.implementationsTree.getRowForPath(path));
        }
        this.tabs.setSelectedIndex(1);
        this.redraw();
    }

    public void showCalls(boolean recurse) {
        if (this.cursorReference == null) {
            return;
        }
        if (this.cursorReference.entry instanceof ClassEntry) {
            ClassReferenceTreeNode node = this.controller.getClassReferences((ClassEntry)this.cursorReference.entry);
            this.callsTree.setModel(new DefaultTreeModel(node));
        } else if (this.cursorReference.entry instanceof FieldEntry) {
            FieldReferenceTreeNode node = this.controller.getFieldReferences((FieldEntry)this.cursorReference.entry);
            this.callsTree.setModel(new DefaultTreeModel(node));
        } else if (this.cursorReference.entry instanceof MethodEntry) {
            MethodReferenceTreeNode node = this.controller.getMethodReferences((MethodEntry)this.cursorReference.entry, recurse);
            this.callsTree.setModel(new DefaultTreeModel(node));
        }
        this.tabs.setSelectedIndex(2);
        this.redraw();
    }

    public void toggleMapping() {
        Object obfEntry = this.cursorReference.entry;
        Entry deobfEntry = (Entry)this.controller.project.getMapper().deobfuscate(obfEntry);
        if (!Objects.equals(obfEntry, deobfEntry)) {
            this.controller.removeMapping(this.cursorReference);
        } else {
            this.controller.markAsDeobfuscated(this.cursorReference);
        }
    }

    private TreePath getPathToRoot(TreeNode node) {
        ArrayList<TreeNode> nodes = Lists.newArrayList();
        TreeNode n = node;
        do {
            nodes.add(n);
        } while ((n = n.getParent()) != null);
        Collections.reverse(nodes);
        return new TreePath(nodes.toArray());
    }

    public void showDiscardDiag(Function<Integer, Void> callback, String ... options) {
        int response = JOptionPane.showOptionDialog(this.frame, I18n.translate("prompt.close.summary"), I18n.translate("prompt.close.title"), 1, 3, null, options, options[2]);
        callback.apply(response);
    }

    public void saveMapping() {
        if (this.enigmaMappingsFileChooser.getSelectedFile() != null || this.enigmaMappingsFileChooser.showSaveDialog(this.frame) == 0) {
            this.controller.saveMappings(this.enigmaMappingsFileChooser.getSelectedFile().toPath());
        }
    }

    public void close() {
        if (!this.controller.isDirty()) {
            this.frame.dispose();
            System.exit(0);
        } else {
            this.showDiscardDiag(response -> {
                if (response == 0) {
                    this.saveMapping();
                    this.frame.dispose();
                } else if (response == 1) {
                    this.frame.dispose();
                }
                return null;
            }, I18n.translate("prompt.close.save"), I18n.translate("prompt.close.discard"), I18n.translate("prompt.close.cancel"));
        }
    }

    public void redraw() {
        this.frame.validate();
        this.frame.repaint();
    }

    public void onPanelRename(Object prevData, Object data, DefaultMutableTreeNode node) throws IllegalNameException {
        if (data instanceof String) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                ClassEntry prevDataChild = (ClassEntry)childNode.getUserObject();
                ClassEntry dataChild = new ClassEntry(data + "/" + prevDataChild.getSimpleName());
                this.controller.rename(new EntryReference(prevDataChild, prevDataChild.getFullName()), dataChild.getFullName(), false);
                childNode.setUserObject(dataChild);
            }
            node.setUserObject(data);
            this.deobfPanel.deobfClasses.reload();
        } else if (data instanceof ClassEntry) {
            this.controller.rename(new EntryReference((ClassEntry)prevData, ((ClassEntry)prevData).getFullName()), ((ClassEntry)data).getFullName(), false);
        }
    }

    public void moveClassTree(EntryReference<Entry<?>, Entry<?>> obfReference, String newName) {
        String oldEntry = obfReference.entry.getContainingClass().getPackageName();
        String newEntry = new ClassEntry(newName).getPackageName();
        this.moveClassTree(obfReference, oldEntry == null, newEntry == null);
    }

    public void moveClassTree(EntryReference<Entry<?>, Entry<?>> obfReference, boolean isOldOb, boolean isNewOb) {
        ClassEntry classEntry = obfReference.entry.getContainingClass();
        List<ClassSelector.StateEntry> stateDeobf = this.deobfPanel.deobfClasses.getExpansionState(this.deobfPanel.deobfClasses);
        List<ClassSelector.StateEntry> stateObf = this.obfPanel.obfClasses.getExpansionState(this.obfPanel.obfClasses);
        if (isOldOb && !isNewOb) {
            this.deobfPanel.deobfClasses.moveClassIn(classEntry);
            this.obfPanel.obfClasses.moveClassOut(classEntry);
            this.deobfPanel.deobfClasses.reload();
            this.obfPanel.obfClasses.reload();
        } else if (isNewOb && !isOldOb) {
            this.obfPanel.obfClasses.moveClassIn(classEntry);
            this.deobfPanel.deobfClasses.moveClassOut(classEntry);
            this.deobfPanel.deobfClasses.reload();
            this.obfPanel.obfClasses.reload();
        } else if (isOldOb) {
            this.obfPanel.obfClasses.moveClassIn(classEntry);
            this.obfPanel.obfClasses.reload();
        } else {
            this.deobfPanel.deobfClasses.moveClassIn(classEntry);
            this.deobfPanel.deobfClasses.reload();
        }
        this.deobfPanel.deobfClasses.restoreExpansionState(this.deobfPanel.deobfClasses, stateDeobf);
        this.obfPanel.obfClasses.restoreExpansionState(this.obfPanel.obfClasses, stateObf);
    }

    public PanelDeobf getDeobfPanel() {
        return this.deobfPanel;
    }

    public void setShouldNavigateOnClick(boolean shouldNavigateOnClick) {
        this.shouldNavigateOnClick = shouldNavigateOnClick;
    }
}

