/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import cuchaz.enigma.Enigma;
import cuchaz.enigma.EnigmaProfile;
import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.ClassReferenceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.FieldReferenceTreeNode;
import cuchaz.enigma.analysis.IndexTreeBuilder;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.MethodReferenceTreeNode;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.api.service.ObfuscationTestService;
import cuchaz.enigma.bytecode.translators.SourceFixVisitor;
import cuchaz.enigma.config.Config;
import cuchaz.enigma.gui.DecompiledClassSource;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.RefreshMode;
import cuchaz.enigma.gui.dialog.ProgressDialog;
import cuchaz.enigma.gui.stats.StatsGenerator;
import cuchaz.enigma.gui.stats.StatsMember;
import cuchaz.enigma.gui.util.History;
import cuchaz.enigma.source.Decompiler;
import cuchaz.enigma.source.DecompilerService;
import cuchaz.enigma.source.Source;
import cuchaz.enigma.source.SourceIndex;
import cuchaz.enigma.source.SourceSettings;
import cuchaz.enigma.throwables.MappingParseException;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.ReadableToken;
import cuchaz.enigma.utils.Utils;
import java.awt.Desktop;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.swing.JOptionPane;
import org.objectweb.asm.tree.ClassNode;

public class GuiController {
    private static final ExecutorService DECOMPILER_SERVICE = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("decompiler-thread").build());
    private final Gui gui;
    public final Enigma enigma;
    public EnigmaProject project;
    private DecompilerService decompilerService;
    private Decompiler decompiler;
    private IndexTreeBuilder indexTreeBuilder;
    private Path loadedMappingPath;
    private MappingFormat loadedMappingFormat;
    private DecompiledClassSource currentSource;
    private Source uncommentedSource;

    public GuiController(Gui gui, EnigmaProfile profile) {
        this.gui = gui;
        this.enigma = Enigma.builder().setProfile(profile).build();
        this.decompilerService = Config.getInstance().decompiler.service;
    }

    public boolean isDirty() {
        return this.project != null && this.project.getMapper().isDirty();
    }

    public CompletableFuture<Void> openJar(Path jarPath) {
        this.gui.onStartOpenJar();
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            this.project = this.enigma.openJar(jarPath, progress);
            this.indexTreeBuilder = new IndexTreeBuilder(this.project.getJarIndex());
            this.decompiler = this.createDecompiler();
            this.gui.onFinishOpenJar(jarPath.getFileName().toString());
            this.refreshClasses();
        });
    }

    private Decompiler createDecompiler() {
        return this.decompilerService.create(name -> {
            ClassNode node = this.project.getClassCache().getClassNode(name);
            if (node == null) {
                return null;
            }
            ClassNode fixedNode = new ClassNode();
            node.accept(new SourceFixVisitor(524288, fixedNode, this.project.getJarIndex()));
            return fixedNode;
        }, new SourceSettings(true, true));
    }

    public void closeJar() {
        this.project = null;
        this.gui.onCloseJar();
    }

    public CompletableFuture<Void> openMappings(MappingFormat format, Path path) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.gui.setMappingsFile(path);
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            try {
                MappingSaveParameters saveParameters = this.enigma.getProfile().getMappingSaveParameters();
                EntryTree<EntryMapping> mappings = format.read(path, progress, saveParameters);
                this.project.setMappings(mappings);
                this.loadedMappingFormat = format;
                this.loadedMappingPath = path;
                this.refreshClasses();
                this.refreshCurrentClass();
            }
            catch (MappingParseException e) {
                JOptionPane.showMessageDialog(this.gui.getFrame(), e.getMessage());
            }
        });
    }

    public CompletableFuture<Void> saveMappings(Path path) {
        return this.saveMappings(path, this.loadedMappingFormat);
    }

    public CompletableFuture<Void> saveMappings(Path path, MappingFormat format) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            EntryRemapper mapper = this.project.getMapper();
            MappingSaveParameters saveParameters = this.enigma.getProfile().getMappingSaveParameters();
            MappingDelta<EntryMapping> delta = mapper.takeMappingDelta();
            boolean saveAll = !path.equals(this.loadedMappingPath);
            this.loadedMappingFormat = format;
            this.loadedMappingPath = path;
            if (saveAll) {
                format.write(mapper.getObfToDeobf(), path, progress, saveParameters);
            } else {
                format.write(mapper.getObfToDeobf(), delta, path, progress, saveParameters);
            }
        });
    }

    public void closeMappings() {
        if (this.project == null) {
            return;
        }
        this.project.setMappings(null);
        this.gui.setMappingsFile(null);
        this.refreshClasses();
        this.refreshCurrentClass();
    }

    public CompletableFuture<Void> dropMappings() {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> this.project.dropMappings(progress));
    }

    public CompletableFuture<Void> exportSource(Path path) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            EnigmaProject.JarExport jar = this.project.exportRemappedJar(progress);
            EnigmaProject.SourceExport source = jar.decompile(progress, this.decompilerService);
            source.write(path, progress);
        });
    }

    public CompletableFuture<Void> exportJar(Path path) {
        if (this.project == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            EnigmaProject.JarExport jar = this.project.exportRemappedJar(progress);
            jar.write(path, progress);
        });
    }

    public Token getToken(int pos) {
        if (this.currentSource == null) {
            return null;
        }
        return this.currentSource.getIndex().getReferenceToken(pos);
    }

    @Nullable
    public EntryReference<Entry<?>, Entry<?>> getReference(Token token) {
        if (this.currentSource == null) {
            return null;
        }
        return this.currentSource.getIndex().getReference(token);
    }

    public ReadableToken getReadableToken(Token token) {
        if (this.currentSource == null) {
            return null;
        }
        SourceIndex index = this.currentSource.getIndex();
        return new ReadableToken(index.getLineNumber(token.start), index.getColumnNumber(token.start), index.getColumnNumber(token.end));
    }

    public void openDeclaration(Entry<?> entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
        this.openReference(new EntryReference(entry, entry.getName()));
    }

    public void openReference(EntryReference<Entry<?>, Entry<?>> reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Reference cannot be null!");
        }
        if (this.gui.referenceHistory == null) {
            this.gui.referenceHistory = new History(reference);
        } else if (!reference.equals(this.gui.referenceHistory.getCurrent())) {
            this.gui.referenceHistory.push(reference);
        }
        this.setReference(reference);
    }

    private void setReference(EntryReference<Entry<?>, Entry<?>> reference) {
        ClassEntry classEntry = reference.getLocationClassEntry();
        if (!this.project.isRenamable(classEntry)) {
            throw new IllegalArgumentException("Obfuscated class " + classEntry + " was not found in the jar!");
        }
        if (this.currentSource == null || !this.currentSource.getEntry().equals(classEntry)) {
            this.loadClass(classEntry, () -> this.showReference(reference));
        } else {
            this.showReference(reference);
        }
    }

    private void showReference(EntryReference<Entry<?>, Entry<?>> reference) {
        Collection<Token> tokens = this.getTokensForReference(reference);
        if (tokens.isEmpty()) {
            System.err.println(String.format("WARNING: no tokens found for %s in %s", reference, this.currentSource.getEntry()));
        } else {
            this.gui.showTokens(tokens);
        }
    }

    public Collection<Token> getTokensForReference(EntryReference<Entry<?>, Entry<?>> reference) {
        EntryRemapper mapper = this.project.getMapper();
        SourceIndex index = this.currentSource.getIndex();
        return mapper.getObfResolver().resolveReference(reference, ResolutionStrategy.RESOLVE_CLOSEST).stream().flatMap(r -> index.getReferenceTokens((EntryReference<Entry<?>, Entry<?>>)r).stream()).collect(Collectors.toList());
    }

    public void openPreviousReference() {
        if (this.hasPreviousReference()) {
            this.setReference(this.gui.referenceHistory.goBack());
        }
    }

    public boolean hasPreviousReference() {
        return this.gui.referenceHistory != null && this.gui.referenceHistory.canGoBack();
    }

    public void openNextReference() {
        if (this.hasNextReference()) {
            this.setReference(this.gui.referenceHistory.goForward());
        }
    }

    public boolean hasNextReference() {
        return this.gui.referenceHistory != null && this.gui.referenceHistory.canGoForward();
    }

    public void navigateTo(Entry<?> entry) {
        if (!this.project.isRenamable(entry)) {
            return;
        }
        this.openDeclaration(entry);
    }

    public void navigateTo(EntryReference<Entry<?>, Entry<?>> reference) {
        if (!this.project.isRenamable(reference.getLocationClassEntry())) {
            return;
        }
        this.openReference(reference);
    }

    private void refreshClasses() {
        ArrayList<ClassEntry> obfClasses = Lists.newArrayList();
        ArrayList<ClassEntry> deobfClasses = Lists.newArrayList();
        this.addSeparatedClasses(obfClasses, deobfClasses);
        this.gui.setObfClasses(obfClasses);
        this.gui.setDeobfClasses(deobfClasses);
    }

    public void addSeparatedClasses(List<ClassEntry> obfClasses, List<ClassEntry> deobfClasses) {
        EntryRemapper mapper = this.project.getMapper();
        Collection<ClassEntry> classes = this.project.getJarIndex().getEntryIndex().getClasses();
        Stream<ClassEntry> visibleClasses = classes.stream().filter(entry -> !entry.isInnerClass());
        visibleClasses.forEach(entry -> {
            ClassEntry deobfEntry = mapper.deobfuscate(entry);
            List<ObfuscationTestService> obfService = this.enigma.getServices().get(ObfuscationTestService.TYPE);
            boolean obfuscated = deobfEntry.equals((ClassEntry)entry);
            if (obfuscated && !obfService.isEmpty() && obfService.stream().anyMatch(service -> service.testDeobfuscated((Entry<?>)entry))) {
                obfuscated = false;
            }
            if (obfuscated) {
                obfClasses.add((ClassEntry)entry);
            } else {
                deobfClasses.add((ClassEntry)entry);
            }
        });
    }

    public void refreshCurrentClass() {
        this.refreshCurrentClass(null);
    }

    private void refreshCurrentClass(EntryReference<Entry<?>, Entry<?>> reference) {
        this.refreshCurrentClass(reference, RefreshMode.MINIMAL);
    }

    private void refreshCurrentClass(EntryReference<Entry<?>, Entry<?>> reference, RefreshMode mode) {
        if (this.currentSource != null) {
            this.loadClass(this.currentSource.getEntry(), () -> {
                if (reference != null) {
                    this.showReference(reference);
                }
            }, mode);
        }
    }

    private void loadClass(ClassEntry classEntry, Runnable callback) {
        this.loadClass(classEntry, callback, RefreshMode.MINIMAL);
    }

    private void loadClass(ClassEntry classEntry, Runnable callback, RefreshMode mode) {
        boolean requiresDecompile;
        ClassEntry targetClass = classEntry.getOutermostClass();
        boolean bl = requiresDecompile = mode == RefreshMode.FULL || this.currentSource == null || !this.currentSource.getEntry().equals(targetClass);
        if (requiresDecompile) {
            this.currentSource = null;
            this.gui.setEditorText(I18n.translate("info_panel.editor.class.decompiling"));
        }
        DECOMPILER_SERVICE.submit(() -> {
            try {
                if (requiresDecompile || mode == RefreshMode.JAVADOCS) {
                    this.currentSource = this.decompileSource(targetClass, mode == RefreshMode.JAVADOCS);
                }
                this.remapSource(this.project.getMapper().getDeobfuscator());
                callback.run();
            }
            catch (Throwable t) {
                System.err.println("An exception was thrown while decompiling class " + classEntry.getFullName());
                t.printStackTrace(System.err);
            }
        });
    }

    private DecompiledClassSource decompileSource(ClassEntry targetClass, boolean onlyRefreshJavadocs) {
        try {
            Source source;
            if (!onlyRefreshJavadocs || this.currentSource == null || !this.currentSource.getEntry().equals(targetClass)) {
                this.uncommentedSource = this.decompiler.getSource(targetClass.getFullName());
            }
            if ((source = this.uncommentedSource.addJavadocs(this.project.getMapper())) == null) {
                this.gui.setEditorText(I18n.translate("info_panel.editor.class.not_found") + " " + targetClass);
                return DecompiledClassSource.text(targetClass, "Unable to find class");
            }
            SourceIndex index = source.index();
            index.resolveReferences(this.project.getMapper().getObfResolver());
            return new DecompiledClassSource(targetClass, index);
        }
        catch (Throwable t) {
            StringWriter traceWriter = new StringWriter();
            t.printStackTrace(new PrintWriter(traceWriter));
            return DecompiledClassSource.text(targetClass, traceWriter.toString());
        }
    }

    private void remapSource(Translator translator) {
        if (this.currentSource == null) {
            return;
        }
        this.currentSource.remapSource(this.project, translator);
        this.gui.setEditorTheme(Config.getInstance().lookAndFeel);
        this.gui.setSource(this.currentSource);
    }

    public void modifierChange(ItemEvent event) {
        if (event.getStateChange() == 1) {
            EntryRemapper mapper = this.project.getMapper();
            Object entry = this.gui.cursorReference.entry;
            AccessModifier modifier = (AccessModifier)((Object)event.getItem());
            EntryMapping mapping = mapper.getDeobfMapping((Entry<?>)entry);
            if (mapping != null) {
                mapper.mapFromObf(entry, new EntryMapping(mapping.getTargetName(), modifier));
            } else {
                mapper.mapFromObf(entry, new EntryMapping(entry.getName(), modifier));
            }
            this.refreshCurrentClass();
        }
    }

    public ClassInheritanceTreeNode getClassInheritance(ClassEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        ClassInheritanceTreeNode rootNode = this.indexTreeBuilder.buildClassInheritance(translator, entry);
        return ClassInheritanceTreeNode.findNode(rootNode, entry);
    }

    public ClassImplementationsTreeNode getClassImplementations(ClassEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        return this.indexTreeBuilder.buildClassImplementations(translator, entry);
    }

    public MethodInheritanceTreeNode getMethodInheritance(MethodEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        MethodInheritanceTreeNode rootNode = this.indexTreeBuilder.buildMethodInheritance(translator, entry);
        return MethodInheritanceTreeNode.findNode(rootNode, entry);
    }

    public MethodImplementationsTreeNode getMethodImplementations(MethodEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        List<MethodImplementationsTreeNode> rootNodes = this.indexTreeBuilder.buildMethodImplementations(translator, entry);
        if (rootNodes.isEmpty()) {
            return null;
        }
        if (rootNodes.size() > 1) {
            System.err.println("WARNING: Method " + entry + " implements multiple interfaces. Only showing first one.");
        }
        return MethodImplementationsTreeNode.findNode(rootNodes.get(0), entry);
    }

    public ClassReferenceTreeNode getClassReferences(ClassEntry entry) {
        Translator deobfuscator = this.project.getMapper().getDeobfuscator();
        ClassReferenceTreeNode rootNode = new ClassReferenceTreeNode(deobfuscator, entry);
        rootNode.load(this.project.getJarIndex(), true);
        return rootNode;
    }

    public FieldReferenceTreeNode getFieldReferences(FieldEntry entry) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        FieldReferenceTreeNode rootNode = new FieldReferenceTreeNode(translator, entry);
        rootNode.load(this.project.getJarIndex(), true);
        return rootNode;
    }

    public MethodReferenceTreeNode getMethodReferences(MethodEntry entry, boolean recursive) {
        Translator translator = this.project.getMapper().getDeobfuscator();
        MethodReferenceTreeNode rootNode = new MethodReferenceTreeNode(translator, entry);
        rootNode.load(this.project.getJarIndex(), true, recursive);
        return rootNode;
    }

    public void rename(EntryReference<Entry<?>, Entry<?>> reference, String newName, boolean refreshClassTree) {
        Entry<?> entry = reference.getNameableEntry();
        this.project.getMapper().mapFromObf(entry, new EntryMapping(newName));
        if (refreshClassTree && reference.entry instanceof ClassEntry && !((ClassEntry)reference.entry).isInnerClass()) {
            this.gui.moveClassTree(reference, newName);
        }
        this.refreshCurrentClass(reference);
    }

    public void removeMapping(EntryReference<Entry<?>, Entry<?>> reference) {
        this.project.getMapper().removeByObf(reference.getNameableEntry());
        if (reference.entry instanceof ClassEntry) {
            this.gui.moveClassTree(reference, false, true);
        }
        this.refreshCurrentClass(reference);
    }

    public void changeDocs(EntryReference<Entry<?>, Entry<?>> reference, String updatedDocs) {
        this.changeDoc((Entry<?>)reference.entry, updatedDocs);
        this.refreshCurrentClass(reference, RefreshMode.JAVADOCS);
    }

    public void changeDoc(Entry<?> obfEntry, String newDoc) {
        EntryRemapper mapper = this.project.getMapper();
        if (mapper.getDeobfMapping(obfEntry) == null) {
            this.markAsDeobfuscated(obfEntry, false);
        }
        mapper.mapFromObf(obfEntry, mapper.getDeobfMapping(obfEntry).withDocs(newDoc), false);
    }

    public void markAsDeobfuscated(Entry<?> obfEntry, boolean renaming) {
        EntryRemapper mapper = this.project.getMapper();
        mapper.mapFromObf(obfEntry, new EntryMapping(mapper.deobfuscate(obfEntry).getName()), renaming);
    }

    public void markAsDeobfuscated(EntryReference<Entry<?>, Entry<?>> reference) {
        EntryRemapper mapper = this.project.getMapper();
        Entry<?> entry = reference.getNameableEntry();
        mapper.mapFromObf(entry, new EntryMapping(mapper.deobfuscate(entry).getName()));
        if (reference.entry instanceof ClassEntry && !((ClassEntry)reference.entry).isInnerClass()) {
            this.gui.moveClassTree(reference, true, false);
        }
        this.refreshCurrentClass(reference);
    }

    public void openStats(Set<StatsMember> includedMembers) {
        ProgressDialog.runOffThread(this.gui.getFrame(), progress -> {
            String data = new StatsGenerator(this.project).generate(progress, includedMembers);
            try {
                File statsFile = File.createTempFile("stats", ".html");
                try (FileWriter w = new FileWriter(statsFile);){
                    w.write(Utils.readResourceToString("/stats.html").replace("/*data*/", data));
                }
                Desktop.getDesktop().open(statsFile);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        });
    }

    public void setDecompiler(DecompilerService service) {
        this.uncommentedSource = null;
        this.decompilerService = service;
        this.decompiler = this.createDecompiler();
        this.refreshCurrentClass(null, RefreshMode.FULL);
    }
}

