/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.command;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.throwables.MappingParseException;
import cuchaz.enigma.translation.MappingTranslator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.VoidEntryResolver;
import cuchaz.enigma.translation.mapping.serde.EnigmaMappingsReader;
import cuchaz.enigma.translation.mapping.serde.EnigmaMappingsWriter;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.translation.mapping.serde.TinyMappingsReader;
import cuchaz.enigma.translation.mapping.serde.TinyMappingsWriter;
import cuchaz.enigma.translation.mapping.serde.TinyV2Writer;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;

public final class MappingCommandsUtil {
    private MappingCommandsUtil() {
    }

    public static EntryTree<EntryMapping> invert(EntryTree<EntryMapping> mappings) {
        MappingTranslator translator = new MappingTranslator(mappings, VoidEntryResolver.INSTANCE);
        HashEntryTree<EntryMapping> result = new HashEntryTree<EntryMapping>();
        for (EntryTreeNode entryTreeNode : mappings) {
            Entry<?> leftEntry = entryTreeNode.getEntry();
            EntryMapping leftMapping = (EntryMapping)entryTreeNode.getValue();
            if (!(leftEntry instanceof ClassEntry || leftEntry instanceof MethodEntry || leftEntry instanceof FieldEntry)) {
                result.insert(translator.translate(leftEntry), leftMapping);
                continue;
            }
            Entry<?> rightEntry = translator.translate(leftEntry);
            result.insert(rightEntry, leftMapping == null ? null : new EntryMapping(leftEntry.getName()));
        }
        return result;
    }

    public static EntryTree<EntryMapping> compose(EntryTree<EntryMapping> left, EntryTree<EntryMapping> right, boolean keepLeftOnly, boolean keepRightOnly) {
        MappingTranslator leftTranslator = new MappingTranslator(left, VoidEntryResolver.INSTANCE);
        HashEntryTree<EntryMapping> result = new HashEntryTree<EntryMapping>();
        HashSet addedMappings = new HashSet();
        for (EntryTreeNode entryTreeNode : left) {
            Entry<?> entry = entryTreeNode.getEntry();
            EntryMapping leftMapping = (EntryMapping)entryTreeNode.getValue();
            Entry<?> rightEntry = leftTranslator.translate(entry);
            EntryMapping rightMapping = (EntryMapping)right.get(rightEntry);
            if (rightMapping != null) {
                result.insert(entry, rightMapping);
                addedMappings.add(rightEntry);
                continue;
            }
            if (!keepLeftOnly) continue;
            result.insert(entry, leftMapping);
        }
        if (keepRightOnly) {
            MappingTranslator leftInverseTranslator = new MappingTranslator(MappingCommandsUtil.invert(left), VoidEntryResolver.INSTANCE);
            for (EntryTreeNode entryTreeNode : right) {
                Entry<?> rightEntry = entryTreeNode.getEntry();
                EntryMapping rightMapping = (EntryMapping)entryTreeNode.getValue();
                if (addedMappings.contains(rightEntry)) continue;
                result.insert(leftInverseTranslator.translate(rightEntry), rightMapping);
            }
        }
        return result;
    }

    public static EntryTree<EntryMapping> read(String type, Path path, MappingSaveParameters saveParameters) throws MappingParseException, IOException {
        MappingFormat format;
        block5: {
            if (type.equals("enigma")) {
                return (Files.isDirectory(path, new LinkOption[0]) ? EnigmaMappingsReader.DIRECTORY : EnigmaMappingsReader.ZIP).read(path, ProgressListener.none(), saveParameters);
            }
            if (type.equals("tiny")) {
                return TinyMappingsReader.INSTANCE.read(path, ProgressListener.none(), saveParameters);
            }
            format = null;
            try {
                format = MappingFormat.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException ignored) {
                if (!type.equals("tinyv2")) break block5;
                format = MappingFormat.TINY_V2;
            }
        }
        if (format != null) {
            return format.getReader().read(path, ProgressListener.none(), saveParameters);
        }
        throw new IllegalArgumentException("no reader for " + type);
    }

    public static void write(EntryTree<EntryMapping> mappings, String type, Path path, MappingSaveParameters saveParameters) {
        if (type.equals("enigma")) {
            EnigmaMappingsWriter.DIRECTORY.write(mappings, path, ProgressListener.none(), saveParameters);
            return;
        }
        if (type.startsWith("tinyv2:") || type.startsWith("tiny_v2:")) {
            String[] split = type.split(":");
            if (split.length != 3) {
                throw new IllegalArgumentException("specify column names as 'tinyv2:from_namespace:to_namespace'");
            }
            new TinyV2Writer(split[1], split[2]).write(mappings, path, ProgressListener.none(), saveParameters);
            return;
        }
        if (type.startsWith("tiny:")) {
            String[] split = type.split(":");
            if (split.length != 3) {
                throw new IllegalArgumentException("specify column names as 'tiny:from_column:to_column'");
            }
            new TinyMappingsWriter(split[1], split[2]).write(mappings, path, ProgressListener.none(), saveParameters);
            return;
        }
        MappingFormat format = null;
        try {
            format = MappingFormat.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (format != null) {
            format.getWriter().write(mappings, path, ProgressListener.none(), saveParameters);
            return;
        }
        throw new IllegalArgumentException("no writer for " + type);
    }
}

