/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.procyon.transformers;

import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.DepthFirstAstVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;

public class Java8Generics
implements IAstTransform {
    public void run(AstNode compilationUnit) {
        compilationUnit.acceptVisitor((IAstVisitor)new Visitor(), null);
    }

    static class Visitor
    extends DepthFirstAstVisitor<Void, Void> {
        Visitor() {
        }

        public Void visitInvocationExpression(InvocationExpression node, Void data) {
            super.visitInvocationExpression(node, (Object)data);
            if (node.getTarget() instanceof MemberReferenceExpression) {
                MemberReferenceExpression referenceExpression = (MemberReferenceExpression)node.getTarget();
                if (referenceExpression.getTypeArguments().stream().map(t -> {
                    TypeDefinition resolved;
                    TypeReference tr = t.toTypeReference();
                    if (tr.getDeclaringType() != null && (resolved = tr.resolve()) != null) {
                        return resolved;
                    }
                    return tr;
                }).anyMatch(t -> t.isWildcardType() || t instanceof TypeDefinition && ((TypeDefinition)t).isAnonymous())) {
                    referenceExpression.getTypeArguments().clear();
                } else if (referenceExpression.getTypeArguments().stream().allMatch(t -> t.toTypeReference().equals((Object)CommonTypeReferences.Object))) {
                    referenceExpression.getTypeArguments().clear();
                }
            }
            return null;
        }

        public Void visitObjectCreationExpression(ObjectCreationExpression node, Void data) {
            SimpleType simpleType;
            AstNodeCollection typeArguments;
            super.visitObjectCreationExpression(node, (Object)data);
            AstType type = node.getType();
            if (type instanceof SimpleType && !((SimpleType)type).getTypeArguments().isEmpty() && (typeArguments = (simpleType = (SimpleType)type).getTypeArguments()).size() == 1 && ((AstType)typeArguments.firstOrNullObject()).toTypeReference().equals((Object)CommonTypeReferences.Object)) {
                ((Identifier)((AstType)typeArguments.firstOrNullObject()).getChildByRole(Roles.IDENTIFIER)).replaceWith((AstNode)Identifier.create((String)""));
            }
            return null;
        }

        public Void visitCastExpression(CastExpression node, Void data) {
            boolean doReplace = false;
            TypeReference typeReference = node.getType().toTypeReference();
            if (typeReference.isArray() && typeReference.getElementType().isGenericType()) {
                doReplace = true;
            } else if (typeReference.isGenericType()) {
                InvocationExpression invocationExpression;
                Expression target = node.getExpression();
                if (typeReference instanceof IGenericInstance && ((IGenericInstance)typeReference).getTypeArguments().stream().anyMatch(t -> t.isWildcardType())) {
                    doReplace = true;
                } else if (target instanceof InvocationExpression && (invocationExpression = (InvocationExpression)target).getTarget() instanceof MemberReferenceExpression && !((MemberReferenceExpression)invocationExpression.getTarget()).getTypeArguments().isEmpty()) {
                    ((MemberReferenceExpression)invocationExpression.getTarget()).getTypeArguments().clear();
                    doReplace = true;
                }
            }
            super.visitCastExpression(node, (Object)data);
            if (doReplace) {
                node.replaceWith((AstNode)node.getExpression());
            }
            return null;
        }
    }
}

