/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation;

import cuchaz.enigma.translation.mapping.NameValidator;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import java.util.Collection;
import java.util.Locale;

public class LocalNameGenerator {
    public static String generateArgumentName(int index, TypeDescriptor desc, Collection<TypeDescriptor> arguments) {
        boolean uniqueType = arguments.stream().filter(desc::equals).count() <= 1L;
        int nameIndex = index + 1;
        StringBuilder nameBuilder = new StringBuilder(LocalNameGenerator.getTypeName(desc));
        if (!uniqueType || NameValidator.isReserved(nameBuilder.toString())) {
            nameBuilder.append(nameIndex);
        }
        String translatedName = nameBuilder.toString();
        return translatedName;
    }

    public static String generateLocalVariableName(int index, TypeDescriptor desc) {
        int nameIndex = index + 1;
        return LocalNameGenerator.getTypeName(desc) + nameIndex;
    }

    private static String getTypeName(TypeDescriptor desc) {
        if (desc.isPrimitive()) {
            TypeDescriptor.Primitive argCls = desc.getPrimitive();
            return argCls.name().toLowerCase(Locale.ROOT);
        }
        if (desc.isArray()) {
            return "arr";
        }
        if (desc.isType()) {
            String typeName = desc.getTypeEntry().getSimpleName().replace("$", "");
            typeName = typeName.substring(0, 1).toLowerCase(Locale.ROOT) + typeName.substring(1);
            return typeName;
        }
        System.err.println("Encountered invalid argument type descriptor " + desc.toString());
        return "var";
    }
}

