/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.translation.mapping.AccessModifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntryMapping {
    private final String targetName;
    private final AccessModifier accessModifier;
    @Nullable
    private final String javadoc;

    public EntryMapping(@Nonnull String targetName) {
        this(targetName, AccessModifier.UNCHANGED);
    }

    public EntryMapping(@Nonnull String targetName, @Nullable String javadoc) {
        this(targetName, AccessModifier.UNCHANGED, javadoc);
    }

    public EntryMapping(@Nonnull String targetName, AccessModifier accessModifier) {
        this(targetName, accessModifier, null);
    }

    public EntryMapping(@Nonnull String targetName, AccessModifier accessModifier, @Nullable String javadoc) {
        this.targetName = targetName;
        this.accessModifier = accessModifier;
        this.javadoc = javadoc;
    }

    @Nonnull
    public String getTargetName() {
        return this.targetName;
    }

    @Nonnull
    public AccessModifier getAccessModifier() {
        if (this.accessModifier == null) {
            return AccessModifier.UNCHANGED;
        }
        return this.accessModifier;
    }

    @Nullable
    public String getJavadoc() {
        return this.javadoc;
    }

    public EntryMapping withName(String newName) {
        return new EntryMapping(newName, this.accessModifier, this.javadoc);
    }

    public EntryMapping withModifier(AccessModifier newModifier) {
        return new EntryMapping(this.targetName, newModifier, this.javadoc);
    }

    public EntryMapping withDocs(String newDocs) {
        return new EntryMapping(this.targetName, this.accessModifier, newDocs);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EntryMapping) {
            EntryMapping mapping = (EntryMapping)obj;
            return mapping.targetName.equals(this.targetName) && mapping.accessModifier.equals((Object)this.accessModifier);
        }
        return false;
    }

    public int hashCode() {
        return this.targetName.hashCode() + this.accessModifier.hashCode() * 31;
    }
}

