/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.config;

import com.google.common.collect.ImmutableMap;
import cuchaz.enigma.config.Config;
import cuchaz.enigma.gui.EnigmaSyntaxKit;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.highlight.BoxHighlightPainter;
import cuchaz.enigma.gui.highlight.TokenHighlightType;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class Themes {
    public static void setLookAndFeel(Gui gui, Config.LookAndFeel lookAndFeel) {
        Config.getInstance().lookAndFeel = lookAndFeel;
        Themes.updateTheme(gui);
    }

    public static void updateTheme(Gui gui) {
        Config config = Config.getInstance();
        config.lookAndFeel.setGlobalLAF();
        config.lookAndFeel.apply(config);
        try {
            config.saveConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        EnigmaSyntaxKit.invalidate();
        DefaultSyntaxKit.initKit();
        DefaultSyntaxKit.registerContentType((String)"text/enigma-sources", (String)EnigmaSyntaxKit.class.getName());
        gui.boxHighlightPainters = ImmutableMap.of((Object)((Object)TokenHighlightType.OBFUSCATED), (Object)BoxHighlightPainter.create(config.obfuscatedColor, config.obfuscatedColorOutline), (Object)((Object)TokenHighlightType.PROPOSED), (Object)BoxHighlightPainter.create(config.proposedColor, config.proposedColorOutline), (Object)((Object)TokenHighlightType.DEOBFUSCATED), (Object)BoxHighlightPainter.create(config.deobfuscatedColor, config.deobfuscatedColorOutline));
        gui.setEditorTheme(config.lookAndFeel);
        SwingUtilities.updateComponentTreeUI(gui.getFrame());
    }
}

