/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.cfr;

import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.source.SourceIndex;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Set;
import java.util.stream.Collectors;
import org.benf.cfr.reader.bytecode.analysis.types.JavaArrayTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaGenericBaseInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.MethodPrototype;
import org.benf.cfr.reader.bytecode.analysis.types.RawJavaType;
import org.benf.cfr.reader.bytecode.analysis.variables.NamedVariable;
import org.benf.cfr.reader.entities.Field;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.mapping.NullMapping;
import org.benf.cfr.reader.mapping.ObfuscationMapping;
import org.benf.cfr.reader.state.TypeUsageInformation;
import org.benf.cfr.reader.util.collections.SetFactory;
import org.benf.cfr.reader.util.output.DelegatingDumper;
import org.benf.cfr.reader.util.output.Dumpable;
import org.benf.cfr.reader.util.output.Dumper;
import org.benf.cfr.reader.util.output.TypeContext;

public class EnigmaDumper
implements Dumper {
    private int outputCount = 0;
    private int indent;
    private boolean atStart = true;
    private boolean pendingCR = false;
    private final StringBuilder sb = new StringBuilder();
    private final TypeUsageInformation typeUsageInformation;
    private final Set<JavaTypeInstance> emitted = SetFactory.newSet();
    private final SourceIndex index = new SourceIndex();
    private int position;

    public EnigmaDumper(TypeUsageInformation typeUsageInformation) {
        this.typeUsageInformation = typeUsageInformation;
    }

    private void append(String s) {
        this.sb.append(s);
        this.position += s.length();
    }

    private String getDesc(JavaTypeInstance type) {
        if (!type.isUsableType() && type != RawJavaType.VOID) {
            throw new IllegalArgumentException(type.toString());
        }
        if (type instanceof JavaGenericBaseInstance) {
            return this.getDesc(type.getDeGenerifiedType());
        }
        if (type instanceof JavaRefTypeInstance) {
            return "L" + type.getRawName().replace('.', '/') + ";";
        }
        if (type instanceof JavaArrayTypeInstance) {
            return "[" + this.getDesc(((JavaArrayTypeInstance)type).removeAnArrayIndirection());
        }
        if (type instanceof RawJavaType) {
            switch ((RawJavaType)type) {
                case BOOLEAN: {
                    return "Z";
                }
                case BYTE: {
                    return "B";
                }
                case CHAR: {
                    return "C";
                }
                case SHORT: {
                    return "S";
                }
                case INT: {
                    return "I";
                }
                case LONG: {
                    return "J";
                }
                case FLOAT: {
                    return "F";
                }
                case DOUBLE: {
                    return "D";
                }
                case VOID: {
                    return "V";
                }
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    private MethodEntry getMethodEntry(MethodPrototype method) {
        if (method == null || method.getClassType() == null) {
            return null;
        }
        MethodDescriptor desc = new MethodDescriptor(method.getArgs().stream().map(type -> new TypeDescriptor(this.getDesc((JavaTypeInstance)type))).collect(Collectors.toList()), new TypeDescriptor(method.getName().equals("<init>") || method.getName().equals("<clinit>") ? "V" : this.getDesc(method.getReturnType())));
        return new MethodEntry(this.getClassEntry(method.getClassType()), method.getName(), desc);
    }

    private LocalVariableEntry getParameterEntry(MethodPrototype method, int parameterIndex, String name) {
        int variableIndex = method.isInstanceMethod() ? 1 : 0;
        for (int i = 0; i < parameterIndex; ++i) {
            variableIndex += method.getArgs().get(i).getStackType().getComputationCategory();
        }
        return new LocalVariableEntry(this.getMethodEntry(method), variableIndex, name, true, null);
    }

    private FieldEntry getFieldEntry(JavaTypeInstance owner, String name, JavaTypeInstance type) {
        return new FieldEntry(this.getClassEntry(owner), name, new TypeDescriptor(this.getDesc(type)));
    }

    private ClassEntry getClassEntry(JavaTypeInstance type) {
        return new ClassEntry(type.getRawName().replace('.', '/'));
    }

    @Override
    public Dumper beginBlockComment(boolean inline) {
        this.print("/*").newln();
        return this;
    }

    @Override
    public Dumper endBlockComment() {
        this.print(" */").newln();
        return this;
    }

    @Override
    public Dumper label(String s, boolean inline) {
        this.processPendingCR();
        this.append(s);
        this.append(":");
        return this;
    }

    @Override
    public Dumper comment(String s) {
        this.append("// ");
        this.append(s);
        this.append("\n");
        return this;
    }

    @Override
    public void enqueuePendingCarriageReturn() {
        this.pendingCR = true;
    }

    @Override
    public Dumper removePendingCarriageReturn() {
        this.pendingCR = false;
        return this;
    }

    private void processPendingCR() {
        if (this.pendingCR) {
            this.append("\n");
            this.atStart = true;
            this.pendingCR = false;
        }
    }

    @Override
    public Dumper identifier(String s, Object ref, boolean defines) {
        return this.print(s);
    }

    @Override
    public Dumper methodName(String name, MethodPrototype method, boolean special, boolean defines) {
        this.doIndent();
        Token token = new Token(this.position, this.position + name.length(), name);
        MethodEntry entry = this.getMethodEntry(method);
        if (entry != null) {
            if (defines) {
                this.index.addDeclaration(token, entry);
            } else {
                this.index.addReference(token, entry, null);
            }
        }
        return this.identifier(name, null, defines);
    }

    public Dumper parameterName(String name, MethodPrototype method, int index, boolean defines) {
        this.doIndent();
        Token token = new Token(this.position, this.position + name.length(), name);
        LocalVariableEntry entry = this.getParameterEntry(method, index, name);
        if (entry != null) {
            if (defines) {
                this.index.addDeclaration(token, entry);
            } else {
                this.index.addReference(token, entry, null);
            }
        }
        return this.identifier(name, null, defines);
    }

    public Dumper variableName(String name, NamedVariable variable, boolean defines) {
        return this.identifier(name, null, defines);
    }

    @Override
    public Dumper packageName(JavaRefTypeInstance t) {
        String s = t.getPackageName();
        if (!s.isEmpty()) {
            this.keyword("package ").print(s).endCodeln().newln();
        }
        return this;
    }

    public Dumper fieldName(String name, Field field, JavaTypeInstance owner, boolean hiddenDeclaration, boolean defines) {
        FieldEntry entry;
        this.doIndent();
        Token token = new Token(this.position, this.position + name.length(), name);
        FieldEntry fieldEntry = entry = field == null ? null : this.getFieldEntry(owner, name, field.getJavaTypeInstance());
        if (entry != null) {
            if (defines) {
                this.index.addDeclaration(token, entry);
            } else {
                this.index.addReference(token, entry, null);
            }
        }
        this.identifier(name, null, defines);
        return this;
    }

    @Override
    public Dumper print(String s) {
        this.processPendingCR();
        this.doIndent();
        this.append(s);
        this.atStart = s.endsWith("\n");
        ++this.outputCount;
        return this;
    }

    @Override
    public Dumper print(char c) {
        return this.print(String.valueOf(c));
    }

    @Override
    public Dumper newln() {
        this.append("\n");
        this.atStart = true;
        ++this.outputCount;
        return this;
    }

    @Override
    public Dumper endCodeln() {
        this.append(";\n");
        this.atStart = true;
        ++this.outputCount;
        return this;
    }

    @Override
    public Dumper keyword(String s) {
        this.print(s);
        return this;
    }

    @Override
    public Dumper operator(String s) {
        this.print(s);
        return this;
    }

    @Override
    public Dumper separator(String s) {
        this.print(s);
        return this;
    }

    @Override
    public Dumper literal(String s, Object o) {
        this.print(s);
        return this;
    }

    private void doIndent() {
        if (!this.atStart) {
            return;
        }
        String indents = "    ";
        for (int x = 0; x < this.indent; ++x) {
            this.append(indents);
        }
        this.atStart = false;
    }

    @Override
    public void indent(int diff) {
        this.indent += diff;
    }

    @Override
    public Dumper dump(Dumpable d) {
        if (d == null) {
            this.keyword("null");
            return this;
        }
        d.dump(this);
        return this;
    }

    @Override
    public TypeUsageInformation getTypeUsageInformation() {
        return this.typeUsageInformation;
    }

    @Override
    public ObfuscationMapping getObfuscationMapping() {
        return NullMapping.INSTANCE;
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void addSummaryError(Method method, String s) {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean canEmitClass(JavaTypeInstance type) {
        return this.emitted.add(type);
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    @Override
    public Dumper dump(JavaTypeInstance type) {
        return this.dump(type, TypeContext.None, false);
    }

    public Dumper dump(JavaTypeInstance type, boolean defines) {
        return this.dump(type, TypeContext.None, false);
    }

    @Override
    public Dumper dump(JavaTypeInstance type, TypeContext context) {
        return this.dump(type, context, false);
    }

    private Dumper dump(JavaTypeInstance type, TypeContext context, boolean defines) {
        this.doIndent();
        if (type instanceof JavaRefTypeInstance) {
            int start = this.position;
            type.dumpInto(this, this.typeUsageInformation, TypeContext.None);
            int end = this.position;
            Token token = new Token(start, end, this.sb.toString().substring(start, end));
            if (defines) {
                this.index.addDeclaration(token, this.getClassEntry(type));
            } else {
                this.index.addReference(token, this.getClassEntry(type), null);
            }
            return this;
        }
        type.dumpInto(this, this.typeUsageInformation, context);
        return this;
    }

    @Override
    public Dumper withTypeUsageInformation(TypeUsageInformation innerclassTypeUsageInformation) {
        return new WithTypeUsageInformationDumper(this, innerclassTypeUsageInformation);
    }

    public SourceIndex getIndex() {
        this.index.setSource(this.getString());
        return this.index;
    }

    public String getString() {
        return this.sb.toString();
    }

    public static class WithTypeUsageInformationDumper
    extends DelegatingDumper {
        private final TypeUsageInformation typeUsageInformation;

        WithTypeUsageInformationDumper(Dumper delegate, TypeUsageInformation typeUsageInformation) {
            super(delegate);
            this.typeUsageInformation = typeUsageInformation;
        }

        @Override
        public TypeUsageInformation getTypeUsageInformation() {
            return this.typeUsageInformation;
        }

        @Override
        public Dumper dump(JavaTypeInstance javaTypeInstance) {
            return this.dump(javaTypeInstance, TypeContext.None);
        }

        @Override
        public Dumper dump(JavaTypeInstance javaTypeInstance, TypeContext typeContext) {
            javaTypeInstance.dumpInto(this, this.typeUsageInformation, typeContext);
            return this;
        }

        @Override
        public Dumper withTypeUsageInformation(TypeUsageInformation innerclassTypeUsageInformation) {
            return new WithTypeUsageInformationDumper(this.delegate, innerclassTypeUsageInformation);
        }
    }
}

