/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.MappingOperations;
import cuchaz.enigma.translation.mapping.serde.MappingIoConverter;
import cuchaz.enigma.translation.mapping.serde.MappingParseException;
import cuchaz.enigma.translation.mapping.serde.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.serde.enigma.EnigmaMappingsWriter;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.utils.I18n;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.MappingWriter;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.mappingio.tree.VisitOrder;
import net.fabricmc.mappingio.tree.VisitableMappingTree;
import org.jetbrains.annotations.ApiStatus;

public enum MappingFormat {
    ENIGMA_FILE(FileType.MAPPING, net.fabricmc.mappingio.format.MappingFormat.ENIGMA_FILE),
    ENIGMA_DIRECTORY(FileType.DIRECTORY, net.fabricmc.mappingio.format.MappingFormat.ENIGMA_DIR),
    TINY_V2(FileType.TINY, net.fabricmc.mappingio.format.MappingFormat.TINY_2_FILE),
    TINY_FILE(FileType.TINY, net.fabricmc.mappingio.format.MappingFormat.TINY_FILE),
    SRG_FILE(FileType.SRG, net.fabricmc.mappingio.format.MappingFormat.SRG_FILE),
    XSRG_FILE(FileType.XSRG, net.fabricmc.mappingio.format.MappingFormat.XSRG_FILE),
    JAM_FILE(FileType.JAM, net.fabricmc.mappingio.format.MappingFormat.JAM_FILE),
    CSRG_FILE(FileType.CSRG, net.fabricmc.mappingio.format.MappingFormat.CSRG_FILE),
    TSRG_FILE(FileType.TSRG, net.fabricmc.mappingio.format.MappingFormat.TSRG_FILE),
    TSRG_2_FILE(FileType.TSRG, net.fabricmc.mappingio.format.MappingFormat.TSRG_2_FILE),
    PROGUARD(FileType.TXT, net.fabricmc.mappingio.format.MappingFormat.PROGUARD_FILE),
    RECAF(FileType.TXT, net.fabricmc.mappingio.format.MappingFormat.RECAF_SIMPLE_FILE),
    JOBF_FILE(FileType.JOBF, net.fabricmc.mappingio.format.MappingFormat.JOBF_FILE),
    INTELLIJ_MIGRATION_MAP_FILE(FileType.XML, net.fabricmc.mappingio.format.MappingFormat.INTELLIJ_MIGRATION_MAP_FILE);

    private final FileType fileType;
    private final net.fabricmc.mappingio.format.MappingFormat mappingIoCounterpart;
    private boolean usedMappingIoWriterLast;

    private MappingFormat(FileType fileType, net.fabricmc.mappingio.format.MappingFormat mappingIoCounterpart) {
        this.fileType = fileType;
        this.mappingIoCounterpart = Objects.requireNonNull(mappingIoCounterpart);
    }

    public void write(EntryTree<EntryMapping> mappings, Path path, ProgressListener progressListener, MappingSaveParameters saveParameters) {
        this.write(mappings, MappingDelta.added(mappings), path, progressListener, saveParameters);
    }

    public void write(EntryTree<EntryMapping> mappings, MappingDelta<EntryMapping> delta, Path path, ProgressListener progressListener, MappingSaveParameters saveParameters) {
        if (!this.isWritable()) {
            throw new UnsupportedOperationException("Mapping format " + String.valueOf((Object)this) + " does not support writing");
        }
        try {
            if (this == ENIGMA_DIRECTORY) {
                EnigmaMappingsWriter.DIRECTORY.write(mappings, this.usedMappingIoWriterLast ? MappingDelta.added(mappings) : delta, path, progressListener, saveParameters, true);
                this.usedMappingIoWriterLast = false;
            } else {
                if (this == PROGUARD) {
                    mappings = MappingOperations.invert(mappings);
                }
                VisitableMappingTree tree = MappingIoConverter.toMappingIo(mappings, progressListener);
                progressListener.init(1, I18n.translate("progress.mappings.writing"));
                progressListener.step(1, null);
                tree.accept((MappingVisitor)MappingWriter.create((Path)path, (net.fabricmc.mappingio.format.MappingFormat)this.mappingIoCounterpart), VisitOrder.createByName());
                progressListener.step(1, I18n.translate("progress.done"));
                this.usedMappingIoWriterLast = true;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    public EntryTree<EntryMapping> read(Path path, ProgressListener progressListener, MappingSaveParameters saveParameters) throws IOException, MappingParseException {
        return this.read(path, progressListener, saveParameters, null);
    }

    public EntryTree<EntryMapping> read(Path path, ProgressListener progressListener, MappingSaveParameters saveParameters, JarIndex index) throws IOException, MappingParseException {
        String loadingMessage = this.mappingIoCounterpart.hasSingleFile() ? I18n.translate("progress.mappings.loading_file") : I18n.translate("progress.mappings.loading_directory");
        progressListener.init(1, loadingMessage);
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        MappingReader.read((Path)path, (net.fabricmc.mappingio.format.MappingFormat)this.mappingIoCounterpart, (MappingVisitor)mappingTree);
        EntryTree<EntryMapping> mappings = MappingIoConverter.fromMappingIo((VisitableMappingTree)mappingTree, progressListener, index);
        return this == PROGUARD ? MappingOperations.invert(mappings) : mappings;
    }

    @ApiStatus.Internal
    public FileType getFileType() {
        return this.fileType;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return this.mappingIoCounterpart.hasWriter;
    }

    public static List<MappingFormat> getReadableFormats() {
        return Arrays.stream(MappingFormat.values()).filter(MappingFormat::isReadable).toList();
    }

    public static List<MappingFormat> getWritableFormats() {
        return Arrays.stream(MappingFormat.values()).filter(MappingFormat::isWritable).toList();
    }

    @ApiStatus.Internal
    public record FileType(List<String> extensions) {
        public static final FileType DIRECTORY = new FileType(new String[0]);
        public static final FileType MAPPING = new FileType(".mapping", ".mappings");
        public static final FileType TINY = new FileType(".tiny");
        public static final FileType SRG = new FileType(".srg");
        public static final FileType XSRG = new FileType(".xsrg");
        public static final FileType JAM = new FileType(".jam");
        public static final FileType CSRG = new FileType(".csrg");
        public static final FileType TSRG = new FileType(".tsrg");
        public static final FileType TXT = new FileType(".txt");
        public static final FileType JOBF = new FileType(".jobf");
        public static final FileType XML = new FileType(".xml");

        public FileType(String ... extensions) {
            this(List.of(extensions));
        }

        public boolean isDirectory() {
            return this.extensions.isEmpty();
        }
    }
}

