/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import cuchaz.enigma.api.view.entry.MethodEntryView;
import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MethodEntry
extends ParentedEntry<ClassEntry>
implements Comparable<MethodEntry>,
MethodEntryView {
    protected final MethodDescriptor descriptor;

    public MethodEntry(ClassEntry parent, String name, MethodDescriptor descriptor) {
        this(parent, name, descriptor, null);
    }

    public MethodEntry(ClassEntry parent, String name, MethodDescriptor descriptor, String javadocs) {
        super(Objects.requireNonNull(parent, "Parent cannot be null"), name, javadocs);
        this.descriptor = Objects.requireNonNull(descriptor, "Method descriptor cannot be null");
    }

    public static MethodEntry parse(String owner, String name, String desc) {
        return new MethodEntry(new ClassEntry(owner), name, new MethodDescriptor(desc), null);
    }

    @Override
    public Class<ClassEntry> getParentType() {
        return ClassEntry.class;
    }

    public MethodDescriptor getDesc() {
        return this.descriptor;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor.toString();
    }

    public boolean isConstructor() {
        return this.name.equals("<init>") || this.name.equals("<clinit>");
    }

    @Override
    protected TranslateResult<? extends MethodEntry> extendedTranslate(Translator translator, @NotNull EntryMapping mapping) {
        String translatedName = mapping.targetName() != null ? mapping.targetName() : this.name;
        String docs = mapping.javadoc();
        return TranslateResult.of(mapping.targetName() == null ? RenamableTokenType.OBFUSCATED : RenamableTokenType.DEOBFUSCATED, new MethodEntry((ClassEntry)this.parent, translatedName, translator.translate(this.descriptor), docs));
    }

    @Override
    public MethodEntry withName(String name) {
        return new MethodEntry((ClassEntry)this.parent, name, this.descriptor, this.javadocs);
    }

    public MethodEntry withDesc(MethodDescriptor descriptor) {
        return new MethodEntry((ClassEntry)this.parent, this.name, descriptor, this.javadocs);
    }

    public MethodEntry withParent(ClassEntry parent) {
        return new MethodEntry(new ClassEntry(parent.getFullName()), this.name, this.descriptor, this.javadocs);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name, this.descriptor);
    }

    public boolean equals(Object other) {
        return other instanceof MethodEntry && this.equals((MethodEntry)other);
    }

    public boolean equals(MethodEntry other) {
        return ((ClassEntry)this.parent).equals((ClassEntry)other.getParent()) && this.name.equals(other.getName()) && this.descriptor.equals(other.getDesc());
    }

    @Override
    public boolean canConflictWith(Entry<?> entry) {
        if (entry instanceof MethodEntry) {
            MethodEntry methodEntry = (MethodEntry)entry;
            return ((ClassEntry)methodEntry.parent).equals((ClassEntry)this.parent) && methodEntry.descriptor.canConflictWith(this.descriptor);
        }
        return false;
    }

    @Override
    public boolean canShadow(Entry<?> entry) {
        return entry instanceof MethodEntry;
    }

    public String toString() {
        return this.getFullName() + String.valueOf(this.descriptor);
    }

    @Override
    public int compareTo(MethodEntry entry) {
        return (this.name + this.descriptor.toString()).compareTo(entry.name + entry.descriptor.toString());
    }
}

