/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.ReferenceTargetType;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.api.view.entry.ClassEntryView;
import cuchaz.enigma.api.view.entry.EntryReferenceView;
import cuchaz.enigma.api.view.entry.FieldEntryView;
import cuchaz.enigma.api.view.entry.MethodEntryView;
import cuchaz.enigma.api.view.index.ReferenceIndexView;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.Lambda;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ReferenceIndex
implements JarIndexer,
ReferenceIndexView {
    private ConcurrentMap<MethodEntry, List<MethodEntry>> methodReferences = new ConcurrentHashMap<MethodEntry, List<MethodEntry>>();
    private ConcurrentMap<MethodEntry, List<EntryReference<MethodEntry, MethodDefEntry>>> referencesToMethods = new ConcurrentHashMap<MethodEntry, List<EntryReference<MethodEntry, MethodDefEntry>>>();
    private ConcurrentMap<ClassEntry, List<EntryReference<ClassEntry, MethodDefEntry>>> referencesToClasses = new ConcurrentHashMap<ClassEntry, List<EntryReference<ClassEntry, MethodDefEntry>>>();
    private ConcurrentMap<FieldEntry, List<EntryReference<FieldEntry, MethodDefEntry>>> referencesToFields = new ConcurrentHashMap<FieldEntry, List<EntryReference<FieldEntry, MethodDefEntry>>>();
    private ConcurrentMap<ClassEntry, List<EntryReference<ClassEntry, FieldDefEntry>>> fieldTypeReferences = new ConcurrentHashMap<ClassEntry, List<EntryReference<ClassEntry, FieldDefEntry>>>();
    private ConcurrentMap<ClassEntry, List<EntryReference<ClassEntry, MethodDefEntry>>> methodTypeReferences = new ConcurrentHashMap<ClassEntry, List<EntryReference<ClassEntry, MethodDefEntry>>>();

    @Override
    public void indexMethod(MethodDefEntry methodEntry) {
        this.indexMethodDescriptor(methodEntry, methodEntry.getDesc());
    }

    private void indexMethodDescriptor(MethodDefEntry entry, MethodDescriptor descriptor) {
        for (TypeDescriptor typeDescriptor : descriptor.getArgumentDescs()) {
            this.indexMethodTypeDescriptor(entry, typeDescriptor);
        }
        this.indexMethodTypeDescriptor(entry, descriptor.getReturnDesc());
    }

    private void indexMethodTypeDescriptor(MethodDefEntry method, TypeDescriptor typeDescriptor) {
        if (typeDescriptor.isType()) {
            ClassEntry referencedClass = typeDescriptor.getTypeEntry();
            JarIndex.synchronizedAdd(this.methodTypeReferences, referencedClass, new EntryReference<ClassEntry, MethodDefEntry>(referencedClass, referencedClass.getName(), method));
        } else if (typeDescriptor.isArray()) {
            this.indexMethodTypeDescriptor(method, typeDescriptor.getArrayType());
        }
    }

    @Override
    public void indexField(FieldDefEntry fieldEntry) {
        this.indexFieldTypeDescriptor(fieldEntry, fieldEntry.getDesc());
    }

    private void indexFieldTypeDescriptor(FieldDefEntry field, TypeDescriptor typeDescriptor) {
        if (typeDescriptor.isType()) {
            ClassEntry referencedClass = typeDescriptor.getTypeEntry();
            JarIndex.synchronizedAdd(this.fieldTypeReferences, referencedClass, new EntryReference<ClassEntry, FieldDefEntry>(referencedClass, referencedClass.getName(), field));
        } else if (typeDescriptor.isArray()) {
            this.indexFieldTypeDescriptor(field, typeDescriptor.getArrayType());
        }
    }

    @Override
    public void indexClassReference(MethodDefEntry callerEntry, ClassEntry referencedEntry, ReferenceTargetType targetType) {
        JarIndex.synchronizedAdd(this.referencesToClasses, referencedEntry, new EntryReference<ClassEntry, MethodDefEntry>(referencedEntry, referencedEntry.getName(), callerEntry, targetType));
    }

    @Override
    public void indexMethodReference(MethodDefEntry callerEntry, MethodEntry referencedEntry, ReferenceTargetType targetType) {
        JarIndex.synchronizedAdd(this.referencesToMethods, referencedEntry, new EntryReference<MethodEntry, MethodDefEntry>(referencedEntry, referencedEntry.getName(), callerEntry, targetType));
        JarIndex.synchronizedAdd(this.methodReferences, callerEntry, referencedEntry);
        if (referencedEntry.isConstructor()) {
            ClassEntry referencedClass = (ClassEntry)referencedEntry.getParent();
            JarIndex.synchronizedAdd(this.referencesToClasses, referencedClass, new EntryReference<ClassEntry, MethodDefEntry>(referencedClass, referencedEntry.getName(), callerEntry, targetType));
        }
    }

    @Override
    public void indexFieldReference(MethodDefEntry callerEntry, FieldEntry referencedEntry, ReferenceTargetType targetType) {
        JarIndex.synchronizedAdd(this.referencesToFields, referencedEntry, new EntryReference<FieldEntry, MethodDefEntry>(referencedEntry, referencedEntry.getName(), callerEntry, targetType));
    }

    @Override
    public void indexLambda(MethodDefEntry callerEntry, Lambda lambda, ReferenceTargetType targetType) {
        if (lambda.getImplMethod() instanceof MethodEntry) {
            this.indexMethodReference(callerEntry, (MethodEntry)lambda.getImplMethod(), targetType);
        } else {
            this.indexFieldReference(callerEntry, (FieldEntry)lambda.getImplMethod(), targetType);
        }
        this.indexMethodDescriptor(callerEntry, lambda.getInvokedType());
        this.indexMethodDescriptor(callerEntry, lambda.getSamMethodType());
        this.indexMethodDescriptor(callerEntry, lambda.getInstantiatedMethodType());
    }

    @Override
    public void processIndex(JarIndex index) {
        this.methodReferences = this.remapReferences(index, this.methodReferences);
        this.referencesToMethods = this.remapReferencesTo(index, this.referencesToMethods);
        this.referencesToClasses = this.remapReferencesTo(index, this.referencesToClasses);
        this.referencesToFields = this.remapReferencesTo(index, this.referencesToFields);
        this.fieldTypeReferences = this.remapReferencesTo(index, this.fieldTypeReferences);
        this.methodTypeReferences = this.remapReferencesTo(index, this.methodTypeReferences);
    }

    private <K extends Entry<?>, V extends Entry<?>> ConcurrentMap<K, List<V>> remapReferences(JarIndex index, ConcurrentMap<K, List<V>> multimap) {
        ConcurrentHashMap resolved = new ConcurrentHashMap();
        multimap.entrySet().parallelStream().forEach(entry -> {
            for (Entry value : (List)entry.getValue()) {
                JarIndex.synchronizedAdd(resolved, this.remap(index, (Entry)entry.getKey()), this.remap(index, value));
            }
        });
        return resolved;
    }

    private <E extends Entry<?>, C extends Entry<?>> ConcurrentMap<E, List<EntryReference<E, C>>> remapReferencesTo(JarIndex index, ConcurrentMap<E, List<EntryReference<E, C>>> multimap) {
        ConcurrentHashMap resolved = new ConcurrentHashMap();
        multimap.entrySet().parallelStream().forEach(entry -> {
            for (EntryReference value : (List)entry.getValue()) {
                JarIndex.synchronizedAdd(resolved, this.remap(index, (Entry)entry.getKey()), this.remap(index, value));
            }
        });
        return resolved;
    }

    private <E extends Entry<?>> E remap(JarIndex index, E entry) {
        return index.getEntryResolver().resolveFirstEntry(entry, ResolutionStrategy.RESOLVE_CLOSEST);
    }

    private <E extends Entry<?>, C extends Entry<?>> EntryReference<E, C> remap(JarIndex index, EntryReference<E, C> reference) {
        return index.getEntryResolver().resolveFirstReference(reference, ResolutionStrategy.RESOLVE_CLOSEST);
    }

    public Collection<MethodEntry> getMethodsReferencedBy(MethodEntry entry) {
        return this.methodReferences.getOrDefault(entry, Collections.emptyList());
    }

    @Override
    public Collection<? extends MethodEntryView> getMethodsReferencedBy(MethodEntryView entry) {
        return this.getMethodsReferencedBy((MethodEntry)entry);
    }

    public Collection<EntryReference<FieldEntry, MethodDefEntry>> getReferencesToField(FieldEntry entry) {
        return this.referencesToFields.getOrDefault(entry, Collections.emptyList());
    }

    @Override
    public Collection<? extends EntryReferenceView> getReferencesToField(FieldEntryView entry) {
        return this.getReferencesToField((FieldEntry)entry);
    }

    public Collection<EntryReference<ClassEntry, MethodDefEntry>> getReferencesToClass(ClassEntry entry) {
        return this.referencesToClasses.getOrDefault(entry, Collections.emptyList());
    }

    @Override
    public Collection<? extends EntryReferenceView> getReferencesToClass(ClassEntryView entry) {
        return this.getReferencesToClass((ClassEntry)entry);
    }

    public Collection<EntryReference<MethodEntry, MethodDefEntry>> getReferencesToMethod(MethodEntry entry) {
        return this.referencesToMethods.getOrDefault(entry, Collections.emptyList());
    }

    @Override
    public Collection<? extends EntryReferenceView> getReferencesToMethod(MethodEntryView entry) {
        return this.getReferencesToMethod((MethodEntry)entry);
    }

    public Collection<EntryReference<ClassEntry, FieldDefEntry>> getFieldTypeReferencesToClass(ClassEntry entry) {
        return this.fieldTypeReferences.getOrDefault(entry, Collections.emptyList());
    }

    @Override
    public Collection<? extends EntryReferenceView> getFieldTypeReferencesToClass(ClassEntryView entry) {
        return this.getFieldTypeReferencesToClass((ClassEntry)entry);
    }

    public Collection<EntryReference<ClassEntry, MethodDefEntry>> getMethodTypeReferencesToClass(ClassEntry entry) {
        return this.methodTypeReferences.getOrDefault(entry, Collections.emptyList());
    }

    @Override
    public Collection<? extends EntryReferenceView> getMethodTypeReferencesToClass(ClassEntryView entry) {
        return this.getMethodTypeReferencesToClass((ClassEntry)entry);
    }
}

