/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.classprovider;

import cuchaz.enigma.classprovider.ClassProvider;
import cuchaz.enigma.utils.AsmUtil;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

public class JarClassProvider
implements AutoCloseable,
ClassProvider {
    private final FileSystem fileSystem;
    private final Set<String> classNames;

    public JarClassProvider(Path jarPath) throws IOException {
        this.fileSystem = FileSystems.newFileSystem(jarPath, (ClassLoader)null);
        this.classNames = JarClassProvider.collectClassNames(this.fileSystem);
    }

    private static Set<String> collectClassNames(FileSystem fileSystem) throws IOException {
        HashSet classNames = new HashSet();
        for (Path root : fileSystem.getRootDirectories()) {
            Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);
            try {
                stream.map(Path::toString).forEach(path -> {
                    if (path.endsWith(".class")) {
                        String name = path.substring(1, path.length() - ".class".length());
                        classNames.add(name);
                    }
                });
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return Collections.unmodifiableSet(classNames);
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    @Override
    @Nullable
    public ClassNode get(String name) {
        if (!this.classNames.contains(name)) {
            return null;
        }
        try {
            return AsmUtil.bytesToNode(Files.readAllBytes(this.fileSystem.getPath(name + ".class", new String[0])));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.fileSystem.close();
    }
}

