/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.bytecode;

import cuchaz.enigma.bytecode.translators.TranslationClassVisitor;
import cuchaz.enigma.source.Source;
import cuchaz.enigma.source.SourceIndex;
import cuchaz.enigma.source.bytecode.EnigmaTextifier;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

public class BytecodeSource
implements Source {
    private final ClassNode classNode;
    private final EntryRemapper remapper;

    public BytecodeSource(ClassNode classNode, EntryRemapper remapper) {
        this.classNode = classNode;
        this.remapper = remapper;
    }

    @Override
    public String asString() {
        return this.index().getSource();
    }

    @Override
    public Source withJavadocs(EntryRemapper remapper) {
        return new BytecodeSource(this.classNode, remapper);
    }

    @Override
    public SourceIndex index() {
        SourceIndex index = new SourceIndex();
        EnigmaTextifier textifier = new EnigmaTextifier(index);
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, (Printer)textifier, writer);
        ClassNode node = this.classNode;
        if (this.remapper != null) {
            ClassNode translatedNode = new ClassNode();
            node.accept((ClassVisitor)new TranslationClassVisitor(this.remapper.getDeobfuscator(), 589824, (ClassVisitor)translatedNode));
            node = translatedNode;
        }
        node.accept((ClassVisitor)traceClassVisitor);
        index.setSource(out.toString());
        return index;
    }
}

