/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.expression.impl.ast.expressions;

import com.llamalad7.mixinextras.expression.impl.ExpressionSource;
import com.llamalad7.mixinextras.expression.impl.ast.expressions.Expression;
import com.llamalad7.mixinextras.expression.impl.ast.expressions.SimpleExpression;
import com.llamalad7.mixinextras.expression.impl.ast.identifiers.TypeIdentifier;
import com.llamalad7.mixinextras.expression.impl.flow.FlowValue;
import com.llamalad7.mixinextras.expression.impl.point.ExpressionContext;
import com.llamalad7.mixinextras.expression.impl.utils.ExpressionASMUtils;
import org.objectweb.asm.Type;

public class CastExpression
extends SimpleExpression {
    private TypeIdentifier a;
    private Expression c;

    public CastExpression(ExpressionSource expressionSource, TypeIdentifier typeIdentifier, Expression expression) {
        super(expressionSource);
        this.a = typeIdentifier;
        this.c = expression;
    }

    @Override
    protected boolean matchesImpl(FlowValue flowValue, ExpressionContext expressionContext) {
        Type type = ExpressionASMUtils.getCastType(flowValue.getInsn());
        return type != null && this.a.matches(expressionContext.a, type) && this.inputsMatch(flowValue, expressionContext, this.c);
    }

    @Override
    public void capture(FlowValue flowValue, ExpressionContext expressionContext) {
        if (flowValue.getInsn().getOpcode() == 192) {
            expressionContext.decorate(flowValue.getInsn(), "mixinextras_simpleOperationArgs", new Type[]{ExpressionASMUtils.a});
            expressionContext.decorate(flowValue.getInsn(), "mixinextras_simpleOperationReturnType", flowValue.getType());
            expressionContext.decorate(flowValue.getInsn(), "mixinextras_simpleOperationParamNames", new String[]{"object"});
        }
        super.capture(flowValue, expressionContext);
    }
}

