/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.expression.impl.ast.expressions;

import com.llamalad7.mixinextras.expression.impl.ExpressionSource;
import com.llamalad7.mixinextras.expression.impl.ast.expressions.SimpleExpression;
import com.llamalad7.mixinextras.expression.impl.ast.identifiers.TypeIdentifier;
import com.llamalad7.mixinextras.expression.impl.flow.FlowValue;
import com.llamalad7.mixinextras.expression.impl.point.ExpressionContext;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;

public class ClassConstantExpression
extends SimpleExpression {
    private TypeIdentifier a;

    public ClassConstantExpression(ExpressionSource expressionSource, TypeIdentifier typeIdentifier) {
        super(expressionSource);
        this.a = typeIdentifier;
    }

    @Override
    protected boolean matchesImpl(FlowValue flowValue, ExpressionContext expressionContext) {
        return (flowValue = this.getConstantType(flowValue.getInsn())) != null && this.a.matches(expressionContext.a, (Type)flowValue);
    }

    private Type getConstantType(AbstractInsnNode object) {
        if (object instanceof LdcInsnNode) {
            object = ((LdcInsnNode)object).cst;
            if (object instanceof Type) {
                return (Type)object;
            }
            return null;
        }
        if (object.getOpcode() != 178) {
            return null;
        }
        object = (FieldInsnNode)object;
        if (!((FieldInsnNode)object).name.equals("TYPE") || !((FieldInsnNode)object).desc.equals(Type.getDescriptor(Class.class))) {
            return null;
        }
        switch (((FieldInsnNode)object).owner) {
            case "java/lang/Boolean": {
                return Type.BOOLEAN_TYPE;
            }
            case "java/lang/Character": {
                return Type.CHAR_TYPE;
            }
            case "java/lang/Byte": {
                return Type.BYTE_TYPE;
            }
            case "java/lang/Short": {
                return Type.SHORT_TYPE;
            }
            case "java/lang/Integer": {
                return Type.INT_TYPE;
            }
            case "java/lang/Float": {
                return Type.FLOAT_TYPE;
            }
            case "java/lang/Long": {
                return Type.LONG_TYPE;
            }
            case "java/lang/Double": {
                return Type.DOUBLE_TYPE;
            }
        }
        return null;
    }
}

