/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.expression.impl.ast.expressions;

import com.llamalad7.mixinextras.expression.impl.ExpressionSource;
import com.llamalad7.mixinextras.expression.impl.flow.FlowValue;
import com.llamalad7.mixinextras.expression.impl.point.ExpressionContext;

public abstract class Expression {
    protected final ExpressionSource b;

    public Expression(ExpressionSource expressionSource) {
        this.b = expressionSource;
    }

    public ExpressionSource getSrc() {
        return this.b;
    }

    public final boolean matches(FlowValue flowValue, ExpressionContext expressionContext) {
        boolean bl = this.matchesImpl(flowValue, expressionContext);
        expressionContext.reportMatchStatus(flowValue, this, bl);
        return bl;
    }

    protected boolean matchesImpl(FlowValue flowValue, ExpressionContext expressionContext) {
        return false;
    }

    protected void capture(FlowValue flowValue, ExpressionContext expressionContext) {
        expressionContext.capture(flowValue, this);
    }

    protected boolean inputsMatch(FlowValue flowValue, ExpressionContext expressionContext, Expression ... expressionArray) {
        return this.inputsMatch(flowValue, expressionContext, false, expressionArray);
    }

    protected boolean inputsMatch(FlowValue flowValue, ExpressionContext expressionContext, boolean bl, Expression ... expressionArray) {
        return this.inputsMatch(0, flowValue, expressionContext, bl, expressionArray);
    }

    protected boolean inputsMatch(int n2, FlowValue flowValue, ExpressionContext expressionContext, Expression ... expressionArray) {
        return this.inputsMatch(n2, flowValue, expressionContext, false, expressionArray);
    }

    protected boolean inputsMatch(int n2, FlowValue flowValue, ExpressionContext expressionContext, boolean n3, Expression ... expressionArray) {
        expressionContext.reportPartialMatch(flowValue, this);
        int n4 = flowValue.inputCount() - n2;
        if ((n3 == 0 || expressionArray.length >= n4) && expressionArray.length != n4) {
            return false;
        }
        for (n3 = 0; n3 < expressionArray.length; ++n3) {
            if (expressionArray[n3].matches(flowValue.getInput(n3 + n2), expressionContext)) continue;
            return false;
        }
        return true;
    }
}

