/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.expression.impl.ast.expressions;

import com.llamalad7.mixinextras.expression.impl.ExpressionSource;
import com.llamalad7.mixinextras.expression.impl.ast.expressions.Expression;
import com.llamalad7.mixinextras.expression.impl.ast.expressions.SimpleExpression;
import com.llamalad7.mixinextras.expression.impl.ast.identifiers.TypeIdentifier;
import com.llamalad7.mixinextras.expression.impl.flow.FlowValue;
import com.llamalad7.mixinextras.expression.impl.point.ExpressionContext;
import com.llamalad7.mixinextras.expression.impl.utils.ExpressionASMUtils;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class NewArrayExpression
extends SimpleExpression {
    private TypeIdentifier a;
    private List c;
    private int d;

    public NewArrayExpression(ExpressionSource expressionSource, TypeIdentifier typeIdentifier, List list, int n2) {
        super(expressionSource);
        this.a = typeIdentifier;
        this.c = list;
        this.d = n2;
    }

    @Override
    protected boolean matchesImpl(FlowValue flowValue, ExpressionContext expressionContext) {
        if (flowValue.hasDecoration("mixinextras_persistent_arrayCreationInfo")) {
            return false;
        }
        Type type = this.getInnerType(flowValue.getInsn());
        if (type == null) {
            return false;
        }
        if (this.getBlankDims(flowValue.getInsn()) + flowValue.inputCount() < this.d + this.c.size()) {
            return false;
        }
        if (!this.a.matches(expressionContext.a, type)) {
            return false;
        }
        ExpressionContext expressionContext2 = expressionContext;
        return this.inputsMatch(flowValue, expressionContext2, expressionContext2.d, this.c.toArray(new Expression[0]));
    }

    private Type getInnerType(AbstractInsnNode abstractInsnNode) {
        switch (abstractInsnNode.getOpcode()) {
            case 189: {
                abstractInsnNode = Type.getObjectType((String)((TypeInsnNode)abstractInsnNode).desc);
                if (abstractInsnNode.getSort() == 9) {
                    return abstractInsnNode.getElementType();
                }
                return abstractInsnNode;
            }
            case 188: {
                return ExpressionASMUtils.getNewArrayType((IntInsnNode)abstractInsnNode);
            }
            case 197: {
                return Type.getType((String)((MultiANewArrayInsnNode)abstractInsnNode).desc).getElementType();
            }
        }
        return null;
    }

    private int getBlankDims(AbstractInsnNode abstractInsnNode) {
        switch (abstractInsnNode.getOpcode()) {
            case 189: {
                abstractInsnNode = Type.getObjectType((String)((TypeInsnNode)abstractInsnNode).desc);
                if (abstractInsnNode.getSort() == 9) {
                    return abstractInsnNode.getDimensions();
                }
                return 0;
            }
            case 197: {
                abstractInsnNode = (MultiANewArrayInsnNode)abstractInsnNode;
                return Type.getType((String)abstractInsnNode.desc).getDimensions() - abstractInsnNode.dims;
            }
        }
        return 0;
    }
}

