/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.expression.impl.flow;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodInsnNode;

public class Boxing {
    static boolean isBoxing(MethodInsnNode methodInsnNode) {
        String string = Boxing.getUnboxingMethod(methodInsnNode.owner);
        if (string == null) {
            return false;
        }
        Type[] typeArray = Type.getArgumentTypes((String)methodInsnNode.desc);
        Type type = Boxing.getUnboxedType(Type.getObjectType((String)methodInsnNode.owner));
        return methodInsnNode.name.equals(string) || methodInsnNode.name.equals("valueOf") && typeArray.length == 1 && typeArray[0].equals((Object)type);
    }

    public static Type getUnboxedType(Type object) {
        if (object.getSort() != 10) {
            return null;
        }
        switch (object.getInternalName()) {
            case "java/lang/Boolean": {
                return Type.BOOLEAN_TYPE;
            }
            case "java/lang/Character": {
                return Type.CHAR_TYPE;
            }
            case "java/lang/Byte": {
                return Type.BYTE_TYPE;
            }
            case "java/lang/Short": {
                return Type.SHORT_TYPE;
            }
            case "java/lang/Integer": {
                return Type.INT_TYPE;
            }
            case "java/lang/Float": {
                return Type.FLOAT_TYPE;
            }
            case "java/lang/Long": {
                return Type.LONG_TYPE;
            }
            case "java/lang/Double": {
                return Type.DOUBLE_TYPE;
            }
        }
        return null;
    }

    private static String getUnboxingMethod(String string) {
        int n2 = -1;
        switch (string.hashCode()) {
            case 1794216884: {
                if (!string.equals("java/lang/Boolean")) break;
                n2 = 0;
                break;
            }
            case 1466314677: {
                if (!string.equals("java/lang/Character")) break;
                n2 = 1;
                break;
            }
            case 202917116: {
                if (!string.equals("java/lang/Byte")) break;
                n2 = 2;
                break;
            }
            case 2010652424: {
                if (!string.equals("java/lang/Short")) break;
                n2 = 3;
                break;
            }
            case -607409974: {
                if (!string.equals("java/lang/Integer")) break;
                n2 = 4;
                break;
            }
            case 1998765288: {
                if (!string.equals("java/lang/Float")) break;
                n2 = 5;
                break;
            }
            case 203205232: {
                if (!string.equals("java/lang/Long")) break;
                n2 = 6;
                break;
            }
            case 1777873605: {
                if (!string.equals("java/lang/Double")) break;
                n2 = 7;
            }
        }
        switch (n2) {
            case 0: {
                return "booleanValue";
            }
            case 1: {
                return "charValue";
            }
            case 2: {
                return "byteValue";
            }
            case 3: {
                return "shortValue";
            }
            case 4: {
                return "intValue";
            }
            case 5: {
                return "floatValue";
            }
            case 6: {
                return "longValue";
            }
            case 7: {
                return "doubleValue";
            }
        }
        return null;
    }
}

