/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.expression.impl.flow;

import com.llamalad7.mixinextras.expression.impl.flow.Boxing;
import com.llamalad7.mixinextras.expression.impl.flow.ComputedFlowValue;
import com.llamalad7.mixinextras.expression.impl.flow.DummyFlowValue;
import com.llamalad7.mixinextras.expression.impl.flow.FlowContext;
import com.llamalad7.mixinextras.expression.impl.flow.FlowInterpreter$1;
import com.llamalad7.mixinextras.expression.impl.flow.FlowValue;
import com.llamalad7.mixinextras.expression.impl.flow.LocalsCalculator;
import com.llamalad7.mixinextras.expression.impl.flow.expansion.IincExpander;
import com.llamalad7.mixinextras.expression.impl.flow.expansion.StringConcatFactoryExpander;
import com.llamalad7.mixinextras.expression.impl.flow.expansion.UnaryComparisonExpander;
import com.llamalad7.mixinextras.expression.impl.flow.postprocessing.CallTaggingPostProcessor;
import com.llamalad7.mixinextras.expression.impl.flow.postprocessing.FlowPostProcessor;
import com.llamalad7.mixinextras.expression.impl.flow.postprocessing.InstantiationPostProcessor;
import com.llamalad7.mixinextras.expression.impl.flow.postprocessing.LMFPostProcessor;
import com.llamalad7.mixinextras.expression.impl.flow.postprocessing.NewArrayPostProcessor;
import com.llamalad7.mixinextras.expression.impl.flow.postprocessing.SplitNodeRemovalPostProcessor;
import com.llamalad7.mixinextras.expression.impl.flow.postprocessing.StringConcatPostProcessor;
import com.llamalad7.mixinextras.expression.impl.utils.ExpressionASMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.spongepowered.asm.util.asm.ASM;

public class FlowInterpreter
extends Interpreter {
    private final FlowContext a;
    private final Map b = new IdentityHashMap();
    private final Map c;
    private final List d;

    protected FlowInterpreter(ClassNode classNode, MethodNode methodNode, FlowContext flowContext) {
        super(ASM.API_VERSION);
        this.a = flowContext;
        this.c = LocalsCalculator.getLocalTypes(classNode, methodNode, flowContext);
        this.d = Arrays.asList(new NewArrayPostProcessor(methodNode), new IincExpander(), new UnaryComparisonExpander(), new StringConcatFactoryExpander(), new InstantiationPostProcessor(), new StringConcatPostProcessor(), new CallTaggingPostProcessor(classNode, methodNode), new LMFPostProcessor(classNode), new SplitNodeRemovalPostProcessor());
    }

    public static Collection analyze(ClassNode classNode, MethodNode methodNode, FlowContext object) {
        object = new FlowInterpreter(classNode, methodNode, (FlowContext)object);
        try {
            new Analyzer((Interpreter)object).analyze(classNode.name, methodNode);
        }
        catch (AnalyzerException analyzerException) {
            throw new RuntimeException("Failed to analyze value flow: ", analyzerException);
        }
        return new ArrayList(((FlowInterpreter)((Object)object)).finish());
    }

    public Collection finish() {
        Set<FlowValue> set = Collections.newSetFromMap(new IdentityHashMap());
        set.addAll(this.b.values());
        Iterator<FlowValue> iterator = set.iterator();
        while (iterator.hasNext()) {
            iterator.next().finish();
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            iterator.next().onFinished();
        }
        for (FlowPostProcessor flowPostProcessor : this.d) {
            Set set2 = Collections.newSetFromMap(new IdentityHashMap());
            ArrayList arrayList = new ArrayList();
            FlowInterpreter$1 flowInterpreter$1 = new FlowInterpreter$1(this, set2, arrayList);
            for (FlowValue flowValue : set) {
                flowPostProcessor.process(flowValue, flowInterpreter$1);
            }
            set.removeAll(set2);
            Iterator<FlowValue> iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().setParents(new FlowValue[0]);
            }
            set.addAll(arrayList);
            iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().finish();
            }
            iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onFinished();
            }
        }
        return set;
    }

    public FlowValue newValue(Type type) {
        if (type == null) {
            return DummyFlowValue.a;
        }
        if (type == Type.VOID_TYPE) {
            return null;
        }
        return new DummyFlowValue(type);
    }

    public FlowValue newOperation(AbstractInsnNode abstractInsnNode) {
        Type type = ExpressionASMUtils.getNewType(abstractInsnNode);
        return this.recordFlow(type, abstractInsnNode, new FlowValue[0]);
    }

    public FlowValue copyOperation(AbstractInsnNode abstractInsnNode, FlowValue flowValue) {
        switch (abstractInsnNode.getOpcode()) {
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return flowValue;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                this.recordFlow(Type.VOID_TYPE, abstractInsnNode, flowValue);
                return new DummyFlowValue(flowValue.getType());
            }
        }
        flowValue = (VarInsnNode)abstractInsnNode;
        flowValue = (Type)this.c.get(flowValue);
        return this.recordFlow((Type)flowValue, abstractInsnNode, new FlowValue[0]);
    }

    public FlowValue unaryOperation(AbstractInsnNode abstractInsnNode, FlowValue flowValue) {
        Type type = ExpressionASMUtils.getUnaryType(abstractInsnNode);
        if (abstractInsnNode.getOpcode() == 132) {
            this.recordFlow(Type.VOID_TYPE, abstractInsnNode, new FlowValue[0]);
            return new DummyFlowValue(type);
        }
        return this.recordFlow(type, abstractInsnNode, flowValue);
    }

    public FlowValue binaryOperation(AbstractInsnNode abstractInsnNode, FlowValue flowValue, FlowValue flowValue2) {
        if (abstractInsnNode.getOpcode() == 50 || abstractInsnNode.getOpcode() == 51) {
            return this.recordComputedFlow(1, flowValueArray -> ExpressionASMUtils.getInnerType(flowValueArray[0].getType()), abstractInsnNode, flowValue, flowValue2);
        }
        Type type = ExpressionASMUtils.getBinaryType(abstractInsnNode, null);
        return this.recordFlow(type, abstractInsnNode, flowValue, flowValue2);
    }

    public FlowValue ternaryOperation(AbstractInsnNode abstractInsnNode, FlowValue flowValue, FlowValue flowValue2, FlowValue flowValue3) {
        return this.recordFlow(Type.VOID_TYPE, abstractInsnNode, flowValue, flowValue2, flowValue3);
    }

    public FlowValue naryOperation(AbstractInsnNode abstractInsnNode, List list) {
        if (abstractInsnNode instanceof MethodInsnNode && Boxing.isBoxing((MethodInsnNode)abstractInsnNode)) {
            return (FlowValue)list.get(0);
        }
        Type type = ExpressionASMUtils.getNaryType(abstractInsnNode);
        return this.recordFlow(type, abstractInsnNode, list.toArray(new FlowValue[0]));
    }

    public void returnOperation(AbstractInsnNode abstractInsnNode, FlowValue flowValue, FlowValue flowValue2) {
    }

    public FlowValue merge(FlowValue flowValue, FlowValue flowValue2) {
        return flowValue.mergeWith(flowValue2, this.a);
    }

    private FlowValue recordFlow(Type type, AbstractInsnNode abstractInsnNode, FlowValue ... flowValueArray) {
        FlowValue flowValue = (FlowValue)this.b.get(abstractInsnNode);
        if (flowValue == null) {
            flowValue = new FlowValue(type, abstractInsnNode, flowValueArray);
            this.b.put(abstractInsnNode, flowValue);
        } else {
            flowValue.mergeInputs(flowValueArray, this.a);
        }
        return flowValue;
    }

    private FlowValue recordComputedFlow(int n2, Function function, AbstractInsnNode abstractInsnNode, FlowValue ... flowValueArray) {
        FlowValue flowValue = (FlowValue)this.b.get(abstractInsnNode);
        if (flowValue == null) {
            flowValue = new ComputedFlowValue(n2, function, abstractInsnNode, flowValueArray);
            this.b.put(abstractInsnNode, flowValue);
        } else {
            flowValue.mergeInputs(flowValueArray, this.a);
        }
        return flowValue;
    }
}

