/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.expression.impl.flow;

import com.llamalad7.mixinextras.expression.impl.flow.FlowContext;
import com.llamalad7.mixinextras.expression.impl.utils.ExpressionASMUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.spongepowered.asm.util.asm.ASM;

class LocalsCalculator
extends Interpreter {
    private final Map a = new IdentityHashMap();
    private final MethodNode b;
    private final FlowContext c;

    /*
     * WARNING - void declaration
     */
    public static Map getLocalTypes(ClassNode object2, MethodNode methodNode, FlowContext flowContext) {
        void var2_4;
        void var1_3;
        LocalsCalculator localsCalculator = new LocalsCalculator((MethodNode)var1_3, (FlowContext)var2_4);
        try {
            new Analyzer((Interpreter)localsCalculator).analyze(((ClassNode)object2).name, (MethodNode)var1_3);
        }
        catch (AnalyzerException analyzerException) {
            throw new RuntimeException(String.format("Failed to calculate locals for %s::%s%s: ", ((ClassNode)object2).name, var1_3.name, var1_3.desc), analyzerException);
        }
        for (Map.Entry entry : localsCalculator.a.entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            Map.Entry entry2 = entry;
            entry2.setValue(((Set)entry2.getValue()).stream().reduce((arg_0, arg_1) -> LocalsCalculator.lambda$getLocalTypes$0((FlowContext)var2_4, arg_0, arg_1)).get());
        }
        return localsCalculator.a;
    }

    private LocalsCalculator(MethodNode methodNode, FlowContext flowContext) {
        super(ASM.API_VERSION);
        this.b = methodNode;
        this.c = flowContext;
    }

    public BasicValue newValue(Type type) {
        if (type == Type.VOID_TYPE) {
            return null;
        }
        if (type == null) {
            type = ExpressionASMUtils.b;
        }
        return new BasicValue(type);
    }

    public BasicValue newOperation(AbstractInsnNode abstractInsnNode) {
        return new BasicValue(ExpressionASMUtils.getNewType(abstractInsnNode));
    }

    public BasicValue copyOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue) {
        if (abstractInsnNode.getOpcode() >= 21 && abstractInsnNode.getOpcode() <= 25) {
            abstractInsnNode = (VarInsnNode)abstractInsnNode;
            this.recordType((VarInsnNode)abstractInsnNode, basicValue.getType());
        }
        return basicValue;
    }

    public BasicValue unaryOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue) {
        return new BasicValue(ExpressionASMUtils.getUnaryType(abstractInsnNode));
    }

    public BasicValue binaryOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue, BasicValue basicValue2) {
        return new BasicValue(ExpressionASMUtils.getBinaryType(abstractInsnNode, basicValue.getType()));
    }

    public BasicValue ternaryOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue, BasicValue basicValue2, BasicValue basicValue3) {
        return null;
    }

    public BasicValue naryOperation(AbstractInsnNode abstractInsnNode, List list) {
        return new BasicValue(ExpressionASMUtils.getNaryType(abstractInsnNode));
    }

    public void returnOperation(AbstractInsnNode abstractInsnNode, BasicValue basicValue, BasicValue basicValue2) {
    }

    public BasicValue merge(BasicValue basicValue, BasicValue basicValue2) {
        if (basicValue.equals((Object)basicValue2)) {
            return basicValue;
        }
        return new BasicValue(ExpressionASMUtils.getCommonSupertype(this.c, basicValue.getType(), basicValue2.getType()));
    }

    private void recordType(VarInsnNode varInsnNode, Type type) {
        Object object = this.a.get(varInsnNode);
        if (object instanceof Type) {
            return;
        }
        if (object instanceof Set) {
            ((Set)object).add(type);
        }
        this.a.put(varInsnNode, (object = this.getLocalVariableAt(varInsnNode)) != null ? Type.getType((String)((LocalVariableNode)object).desc) : new HashSet<Type>(Collections.singleton(type)));
    }

    private LocalVariableNode getLocalVariableAt(VarInsnNode varInsnNode) {
        int n2 = this.b.instructions.indexOf((AbstractInsnNode)varInsnNode);
        int n3 = varInsnNode.var;
        if (this.b.localVariables == null || this.b.localVariables.isEmpty()) {
            return null;
        }
        LocalVariableNode localVariableNode = null;
        for (LocalVariableNode localVariableNode2 : this.b.localVariables) {
            if (localVariableNode2.index != n3 || localVariableNode2.desc == null) continue;
            LocalsCalculator localsCalculator = this;
            if (!localsCalculator.isOpcodeInRange(localsCalculator.b.instructions, localVariableNode2, n2)) continue;
            localVariableNode = localVariableNode2;
        }
        return localVariableNode;
    }

    private boolean isOpcodeInRange(InsnList insnList, LocalVariableNode localVariableNode, int n2) {
        return insnList.indexOf((AbstractInsnNode)localVariableNode.start) <= n2 && insnList.indexOf((AbstractInsnNode)localVariableNode.end) > n2;
    }
}

