/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.expression.impl.flow.postprocessing;

import com.llamalad7.mixinextras.expression.impl.flow.FlowValue;
import com.llamalad7.mixinextras.expression.impl.flow.postprocessing.FlowPostProcessor;
import com.llamalad7.mixinextras.expression.impl.flow.postprocessing.FlowPostProcessor$OutputSink;
import com.llamalad7.mixinextras.expression.impl.flow.postprocessing.MethodCallType;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.util.Bytecode;

public class CallTaggingPostProcessor
implements FlowPostProcessor {
    private final Type a;
    private final boolean b;

    public CallTaggingPostProcessor(ClassNode classNode, MethodNode methodNode) {
        this.a = Type.getObjectType((String)classNode.name);
        this.b = Bytecode.isStatic((MethodNode)methodNode);
    }

    @Override
    public void process(FlowValue flowValue, FlowPostProcessor$OutputSink flowPostProcessor$OutputSink) {
        MethodCallType methodCallType = this.getType(flowValue);
        if (methodCallType == null) {
            return;
        }
        flowValue.decorate("methodCallType", (Object)methodCallType);
        if (methodCallType == MethodCallType.b) {
            flowPostProcessor$OutputSink.markAsSynthetic(flowValue.getInput(0));
            flowValue.removeParent(0);
        }
    }

    private MethodCallType getType(FlowValue flowValue) {
        if (!(flowValue.getInsn() instanceof MethodInsnNode)) {
            return null;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)flowValue.getInsn();
        switch (methodInsnNode.getOpcode()) {
            case 182: 
            case 185: {
                return MethodCallType.a;
            }
            case 184: {
                return MethodCallType.c;
            }
            case 183: {
                if (methodInsnNode.name.equals("<init>")) {
                    return null;
                }
                if (methodInsnNode.owner.equals(this.a.getInternalName())) {
                    return MethodCallType.a;
                }
                if (!this.isLoadThis(flowValue.getInput(0))) break;
                return MethodCallType.b;
            }
        }
        return null;
    }

    private boolean isLoadThis(FlowValue flowValue) {
        if (this.b || flowValue.isComplex() || flowValue.getInsn().getOpcode() != 25) {
            return false;
        }
        return ((VarInsnNode)flowValue.getInsn()).var == 0;
    }
}

