/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.expression.impl.flow.utils;

import com.llamalad7.mixinextras.expression.impl.flow.FlowValue;
import com.llamalad7.mixinextras.expression.impl.flow.expansion.InsnExpander;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class InsnReference {
    private AbstractInsnNode a;

    public InsnReference(FlowValue flowValue) {
        if (flowValue.isComplex()) {
            throw new IllegalArgumentException("Cannot create a reference to a complex flow");
        }
        if (InsnExpander.hasExpansion(flowValue)) {
            InsnExpander.addExpansionStep(flowValue, injectionNode -> {
                this.a = injectionNode.getCurrentTarget();
            });
            return;
        }
        this.a = flowValue.getInsn();
    }

    public InjectionNodes.InjectionNode getNode(Target target) {
        if (this.a == null) {
            throw new UnsupportedOperationException("This flow value has not yet been expanded!");
        }
        InjectionNodes.InjectionNode injectionNode = target.getInjectionNode(this.a);
        if (injectionNode != null) {
            return injectionNode;
        }
        if (!target.insns.contains(this.a)) {
            throw new IllegalArgumentException("This insn is not present in ".concat(String.valueOf(target)));
        }
        return target.addInjectionNode(this.a);
    }
}

