/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.expression.impl.pool;

import com.llamalad7.mixinextras.expression.impl.flow.FlowValue;
import com.llamalad7.mixinextras.expression.impl.pool.ArrayLengthDef;
import com.llamalad7.mixinextras.expression.impl.pool.ExactTypeDef;
import com.llamalad7.mixinextras.expression.impl.pool.MemberDefinition;
import com.llamalad7.mixinextras.expression.impl.pool.TypeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;

public class IdentifierPool {
    private final Map a = new HashMap();
    private final Map b = new HashMap();

    public IdentifierPool() {
        this.addType("byte", new ExactTypeDef(Type.BYTE_TYPE));
        this.addType("char", new ExactTypeDef(Type.CHAR_TYPE));
        this.addType("double", new ExactTypeDef(Type.DOUBLE_TYPE));
        this.addType("float", new ExactTypeDef(Type.FLOAT_TYPE));
        this.addType("int", new ExactTypeDef(Type.INT_TYPE));
        this.addType("long", new ExactTypeDef(Type.LONG_TYPE));
        this.addType("short", new ExactTypeDef(Type.SHORT_TYPE));
        this.addMember("length", new ArrayLengthDef());
    }

    public boolean matchesMember(String string, FlowValue flowValue) {
        List list = (List)this.a.get(string);
        if (list == null) {
            throw new IllegalStateException("Use of undeclared identifier '" + string + '\'');
        }
        return list.stream().anyMatch(memberDefinition -> memberDefinition.matches(flowValue));
    }

    public boolean matchesType(String string, Type type) {
        List list = (List)this.b.get(string);
        if (list == null) {
            throw new IllegalStateException("Use of undeclared identifier '" + string + '\'');
        }
        return list.stream().anyMatch(typeDefinition -> typeDefinition.matches(type));
    }

    public void addMember(String string2, MemberDefinition memberDefinition) {
        this.a.computeIfAbsent(string2, string -> new ArrayList()).add(memberDefinition);
    }

    public void addType(String string2, TypeDefinition typeDefinition) {
        this.b.computeIfAbsent(string2, string -> new ArrayList()).add(typeDefinition);
    }

    public boolean memberExists(String string) {
        return this.a.containsKey(string);
    }

    public boolean typeExists(String string) {
        return this.b.containsKey(string);
    }
}

