/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.expression.impl.utils;

import com.llamalad7.mixinextras.expression.impl.ExpressionService;
import com.llamalad7.mixinextras.expression.impl.flow.Boxing;
import com.llamalad7.mixinextras.expression.impl.flow.FlowContext;
import com.llamalad7.mixinextras.lib.apache.a.e;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.util.Bytecode;

public class ExpressionASMUtils {
    public static final Type a = Type.getType(Object.class);
    public static final Type b = Type.getObjectType((String)"null");
    public static final Type c = Type.getObjectType((String)"int-like");
    public static final Handle d = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", Bytecode.generateDescriptor(CallSite.class, (Object[])new Object[]{MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class}), false);
    public static final Handle e = new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", Bytecode.generateDescriptor(CallSite.class, (Object[])new Object[]{MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class}), false);

    public static Type getNewType(AbstractInsnNode object) {
        switch (object.getOpcode()) {
            case 1: {
                return b;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                return c;
            }
            case 9: 
            case 10: {
                return Type.LONG_TYPE;
            }
            case 11: 
            case 12: 
            case 13: {
                return Type.FLOAT_TYPE;
            }
            case 14: 
            case 15: {
                return Type.DOUBLE_TYPE;
            }
            case 18: {
                object = ((LdcInsnNode)object).cst;
                if (object instanceof Integer) {
                    return c;
                }
                if (object instanceof Float) {
                    return Type.FLOAT_TYPE;
                }
                if (object instanceof Long) {
                    return Type.LONG_TYPE;
                }
                if (object instanceof Double) {
                    return Type.DOUBLE_TYPE;
                }
                if (object instanceof String) {
                    return Type.getType(String.class);
                }
                if (object instanceof Type) {
                    int n2 = ((Type)object).getSort();
                    if (n2 == 10 || n2 == 9) {
                        return Type.getType(Class.class);
                    }
                    if (n2 == 11) {
                        return Type.getType(MethodType.class);
                    }
                }
                if (object instanceof Handle) {
                    return Type.getType(MethodHandle.class);
                }
                throw new IllegalArgumentException("Illegal LDC constant ".concat(String.valueOf(object)));
            }
            case 178: {
                return Type.getType((String)((FieldInsnNode)object).desc);
            }
            case 187: {
                return Type.getObjectType((String)((TypeInsnNode)object).desc);
            }
        }
        throw ExpressionASMUtils.errorFor(object);
    }

    public static Type getUnaryType(AbstractInsnNode object) {
        switch (object.getOpcode()) {
            case 116: 
            case 132: 
            case 136: 
            case 139: 
            case 142: 
            case 190: {
                return Type.INT_TYPE;
            }
            case 145: {
                return Type.BYTE_TYPE;
            }
            case 146: {
                return Type.CHAR_TYPE;
            }
            case 147: {
                return Type.SHORT_TYPE;
            }
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                return Type.FLOAT_TYPE;
            }
            case 117: 
            case 133: 
            case 140: 
            case 143: {
                return Type.LONG_TYPE;
            }
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                return Type.DOUBLE_TYPE;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: 
            case 191: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return Type.VOID_TYPE;
            }
            case 180: {
                return Type.getType((String)((FieldInsnNode)object).desc);
            }
            case 188: {
                switch (((IntInsnNode)object).operand) {
                    case 4: {
                        return Type.getType((String)"[Z");
                    }
                    case 5: {
                        return Type.getType((String)"[C");
                    }
                    case 8: {
                        return Type.getType((String)"[B");
                    }
                    case 9: {
                        return Type.getType((String)"[S");
                    }
                    case 10: {
                        return Type.getType((String)"[I");
                    }
                    case 6: {
                        return Type.getType((String)"[F");
                    }
                    case 7: {
                        return Type.getType((String)"[D");
                    }
                    case 11: {
                        return Type.getType((String)"[J");
                    }
                }
                throw new Error("Invalid array type " + ((IntInsnNode)object).operand);
            }
            case 189: {
                object = ((TypeInsnNode)object).desc;
                return Type.getType((String)("[" + Type.getObjectType((String)object)));
            }
            case 192: {
                return Type.getObjectType((String)((TypeInsnNode)object).desc);
            }
            case 193: {
                return Type.BOOLEAN_TYPE;
            }
        }
        throw ExpressionASMUtils.errorFor(object);
    }

    public static Type getBinaryType(AbstractInsnNode abstractInsnNode, Type type) {
        switch (abstractInsnNode.getOpcode()) {
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return Type.LONG_TYPE;
            }
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return Type.DOUBLE_TYPE;
            }
            case 46: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return Type.INT_TYPE;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return Type.FLOAT_TYPE;
            }
            case 52: {
                return Type.CHAR_TYPE;
            }
            case 53: {
                return Type.SHORT_TYPE;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return Type.VOID_TYPE;
            }
            case 50: 
            case 51: {
                return ExpressionASMUtils.getInnerType(type);
            }
        }
        throw ExpressionASMUtils.errorFor(abstractInsnNode);
    }

    public static Type getNaryType(AbstractInsnNode abstractInsnNode) {
        switch (abstractInsnNode.getOpcode()) {
            case 197: {
                return Type.getType((String)((MultiANewArrayInsnNode)abstractInsnNode).desc);
            }
            case 186: {
                return Type.getReturnType((String)((InvokeDynamicInsnNode)abstractInsnNode).desc);
            }
        }
        return Type.getReturnType((String)((MethodInsnNode)abstractInsnNode).desc);
    }

    private static Error errorFor(AbstractInsnNode abstractInsnNode) {
        return new AssertionError((Object)String.format("Could not compute type of %s! Please inform LlamaLad7!", Bytecode.describeNode((AbstractInsnNode)abstractInsnNode)));
    }

    public static Type getCommonSupertype(FlowContext flowContext, Type type, Type type2) {
        if (type.equals((Object)type2) || type2.equals((Object)b)) {
            return type;
        }
        if (type.equals((Object)b)) {
            return type2;
        }
        int n2 = ExpressionASMUtils.isIntLike(type);
        int n3 = ExpressionASMUtils.isIntLike(type2);
        if (n2 != 0 && n3 != 0) {
            return c;
        }
        if (n2 != 0 || n3 != 0) {
            return b;
        }
        if (type.getSort() == 9 && type2.getSort() == 9) {
            int n4;
            n2 = type.getDimensions();
            type = type.getElementType();
            n3 = type2.getDimensions();
            type2 = type2.getElementType();
            if (n2 == n3) {
                if (type.equals((Object)type2)) {
                    flowContext = type;
                } else if (type.getSort() == 10 && type2.getSort() == 10) {
                    flowContext = ExpressionASMUtils.getCommonSupertype(flowContext, type, type2);
                } else {
                    return ExpressionASMUtils.arrayType(a, n2 - 1);
                }
                return ExpressionASMUtils.arrayType((Type)flowContext, n2);
            }
            if (n2 < n3) {
                flowContext = type;
                n4 = n2 - 1;
            } else {
                flowContext = type2;
                n4 = n3 - 1;
            }
            if (flowContext.getSort() == 10) {
                ++n4;
            }
            return ExpressionASMUtils.arrayType(a, n4);
        }
        if (type.getSort() == 9 && type2.getSort() == 10 || type2.getSort() == 9 && type.getSort() == 10) {
            return a;
        }
        if (type.getSort() != type2.getSort()) {
            return b;
        }
        return ExpressionService.getInstance().getCommonSuperClass(flowContext, type, type2);
    }

    public static Type getCommonIntType(FlowContext flowContext, Type type, Type type2) {
        Type type3 = Boxing.getUnboxedType(type);
        Type type4 = Boxing.getUnboxedType(type2);
        return ExpressionASMUtils.getCommonSupertype(flowContext, type3 != null ? type3 : type, type4 != null ? type4 : type2);
    }

    public static boolean isIntLike(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
            case 10: {
                return type.equals((Object)c);
            }
        }
        return false;
    }

    private static Type arrayType(Type type, int n2) {
        return Type.getType((String)(com.llamalad7.mixinextras.lib.apache.a.e.a('[', n2) + type.getDescriptor()));
    }

    public static Type getInnerType(Type type) {
        if (type.equals((Object)b)) {
            return b;
        }
        return Type.getType((String)type.getDescriptor().substring(1));
    }

    public static Type getNewArrayType(IntInsnNode intInsnNode) {
        switch (intInsnNode.operand) {
            case 4: {
                return Type.BOOLEAN_TYPE;
            }
            case 5: {
                return Type.CHAR_TYPE;
            }
            case 6: {
                return Type.FLOAT_TYPE;
            }
            case 7: {
                return Type.DOUBLE_TYPE;
            }
            case 8: {
                return Type.BYTE_TYPE;
            }
            case 9: {
                return Type.SHORT_TYPE;
            }
            case 10: {
                return Type.INT_TYPE;
            }
            case 11: {
                return Type.LONG_TYPE;
            }
        }
        return null;
    }

    public static Object getConstant(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode.getOpcode() == 188) {
            return null;
        }
        if (abstractInsnNode instanceof TypeInsnNode) {
            return null;
        }
        return Bytecode.getConstant((AbstractInsnNode)abstractInsnNode);
    }

    public static AbstractInsnNode pushInt(int n2) {
        switch (n2) {
            case -1: {
                return new InsnNode(2);
            }
            case 0: {
                return new InsnNode(3);
            }
            case 1: {
                return new InsnNode(4);
            }
            case 2: {
                return new InsnNode(5);
            }
            case 3: {
                return new InsnNode(6);
            }
            case 4: {
                return new InsnNode(7);
            }
            case 5: {
                return new InsnNode(8);
            }
        }
        if (-128 <= n2 && n2 <= 127) {
            return new IntInsnNode(16, n2);
        }
        if (Short.MIN_VALUE <= n2 && n2 <= Short.MAX_VALUE) {
            return new IntInsnNode(17, n2);
        }
        return new LdcInsnNode((Object)n2);
    }

    public static Type getCastType(AbstractInsnNode abstractInsnNode) {
        switch (abstractInsnNode.getOpcode()) {
            case 192: {
                return Type.getObjectType((String)((TypeInsnNode)abstractInsnNode).desc);
            }
            case 136: 
            case 139: 
            case 142: {
                return Type.INT_TYPE;
            }
            case 145: {
                return Type.BYTE_TYPE;
            }
            case 146: {
                return Type.CHAR_TYPE;
            }
            case 147: {
                return Type.SHORT_TYPE;
            }
            case 134: 
            case 137: 
            case 144: {
                return Type.FLOAT_TYPE;
            }
            case 133: 
            case 140: 
            case 143: {
                return Type.LONG_TYPE;
            }
            case 135: 
            case 138: 
            case 141: {
                return Type.DOUBLE_TYPE;
            }
        }
        return null;
    }
}

