/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.injector.wrapoperation;

import com.llamalad7.mixinextras.injector.MixinExtrasLateInjectionInfo;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperationInjector;
import com.llamalad7.mixinextras.utils.ASMUtils;
import com.llamalad7.mixinextras.utils.CompatibilityHelper;
import com.llamalad7.mixinextras.utils.InjectorUtils;
import com.llamalad7.mixinextras.utils.MixinExtrasLogger;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.points.BeforeConstant;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;

@InjectionInfo.AnnotationType(value=WrapOperation.class)
@InjectionInfo.HandlerPrefix(value="wrapOperation")
public class WrapOperationInjectionInfo
extends MixinExtrasLateInjectionInfo {
    private static final MixinExtrasLogger a = MixinExtrasLogger.get("WrapOperation");

    public WrapOperationInjectionInfo(MixinTargetContext mixinTargetContext, MethodNode methodNode, AnnotationNode annotationNode) {
        super(mixinTargetContext, methodNode, annotationNode, WrapOperationInjectionInfo.determineAtKey(mixinTargetContext, methodNode, annotationNode));
    }

    protected Injector parseInjector(AnnotationNode annotationNode) {
        return new WrapOperationInjector(this);
    }

    public void prepare() {
        super.prepare();
        InjectorUtils.checkForDupedNews(this.targetNodes);
        for (Map.Entry entry : this.targetNodes.entrySet()) {
            Target target = (Target)entry.getKey();
            ListIterator object = ((List)entry.getValue()).listIterator();
            while (object.hasNext()) {
                InjectionNodes.InjectionNode injectionNode = (InjectionNodes.InjectionNode)object.next();
                AbstractInsnNode abstractInsnNode = injectionNode.getCurrentTarget();
                if (abstractInsnNode.getOpcode() != 187) continue;
                MethodInsnNode methodInsnNode = ASMUtils.findInitNodeFor(target, (TypeInsnNode)abstractInsnNode);
                if (methodInsnNode == null) {
                    a.warn("NEW node {} in {} has no init call?", Bytecode.describeNode((AbstractInsnNode)abstractInsnNode), target);
                    object.remove();
                    continue;
                }
                injectionNode.decorate("mixinextras_newArgTypes", (Object)Type.getArgumentTypes((String)methodInsnNode.desc));
            }
        }
    }

    protected void parseInjectionPoints(List object) {
        if (this.atKey.equals("at")) {
            super.parseInjectionPoints((List)object);
            return;
        }
        Type type = Type.getReturnType((String)this.method.desc);
        object = object.iterator();
        while (object.hasNext()) {
            AnnotationNode annotationNode = (AnnotationNode)object.next();
            this.injectionPoints.add(new BeforeConstant(CompatibilityHelper.getMixin(this), annotationNode, type.getDescriptor()));
        }
    }

    @Override
    public String getLateInjectionType() {
        return "WrapOperation";
    }

    private static String determineAtKey(MixinTargetContext mixinTargetContext, MethodNode methodNode, AnnotationNode annotationNode) {
        boolean bl;
        boolean bl2 = Annotations.getValue((AnnotationNode)annotationNode, (String)"at") != null;
        boolean bl3 = bl = Annotations.getValue((AnnotationNode)annotationNode, (String)"constant") != null;
        if (bl2 == bl) {
            throw new IllegalStateException(String.format("@WrapOperation injector %s::%s must specify exactly one of `at` and `constant`, got %s.", mixinTargetContext.getMixin().getClassName(), methodNode.name, bl2 ? "both" : "neither"));
        }
        if (bl2) {
            return "at";
        }
        return "constant";
    }
}

