/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.sugar.impl;

import com.llamalad7.mixinextras.injector.StackExtension;
import com.llamalad7.mixinextras.sugar.impl.SugarApplicationException;
import com.llamalad7.mixinextras.sugar.impl.SugarApplicator;
import com.llamalad7.mixinextras.sugar.impl.SugarParameter;
import com.llamalad7.mixinextras.sugar.impl.SugarPostProcessingExtension;
import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefClassGenerator;
import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefUtils;
import com.llamalad7.mixinextras.utils.InjectorUtils;
import java.util.HashMap;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.modify.InvalidImplicitDiscriminatorException;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;

class LocalSugarApplicator
extends SugarApplicator {
    private final boolean f;
    private final Type g;
    private final boolean h;

    LocalSugarApplicator(InjectionInfo injectionInfo, SugarParameter sugarParameter) {
        super(injectionInfo, sugarParameter);
        this.g = LocalRefUtils.getTargetType(this.d, this.e);
        this.h = this.g != this.d;
        this.f = (Boolean)Annotations.getValue((AnnotationNode)this.c, (String)"argsOnly", (Object)Boolean.FALSE);
    }

    @Override
    void validate(Target target, InjectionNodes.InjectionNode injectionNode) {
        LocalVariableDiscriminator localVariableDiscriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.c);
        LocalVariableDiscriminator.Context context = InjectorUtils.getOrCreateLocalContext(target, injectionNode, this.b, this.g, this.f);
        if (localVariableDiscriminator.printLVT()) {
            InjectorUtils.printLocals(target, injectionNode.getCurrentTarget(), context, localVariableDiscriminator, this.g, this.f);
            this.b.addCallbackInvocation(this.b.getMethod());
            throw new SugarApplicationException("Application aborted because locals are being printed instead.");
        }
        try {
            if (localVariableDiscriminator.findLocal(context) < 0) {
                throw new SugarApplicationException("Unable to find matching local!");
            }
            return;
        }
        catch (InvalidImplicitDiscriminatorException invalidImplicitDiscriminatorException) {
            throw new SugarApplicationException("Invalid implicit variable discriminator: ", invalidImplicitDiscriminatorException);
        }
    }

    @Override
    void prepare(Target target, InjectionNodes.InjectionNode injectionNode) {
        InjectorUtils.getOrCreateLocalContext(target, injectionNode, this.b, this.g, this.f);
    }

    @Override
    void inject(Target target, InjectionNodes.InjectionNode injectionNode, StackExtension stackExtension) {
        LocalVariableDiscriminator.Context context;
        LocalVariableDiscriminator localVariableDiscriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.c);
        int n2 = localVariableDiscriminator.findLocal(context = InjectorUtils.getOrCreateLocalContext(target, injectionNode, this.b, this.g, this.f));
        if (n2 < 0) {
            throw new SugarApplicationException("Failed to match a local, this should have been caught during validation.");
        }
        if (this.h) {
            this.initAndLoadLocalRef(target, injectionNode, n2, stackExtension);
            return;
        }
        stackExtension.extra(this.g.getSize());
        target.insns.insertBefore(injectionNode.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(this.g.getOpcode(21), n2));
    }

    @Override
    int postProcessingPriority() {
        return 1000;
    }

    private void initAndLoadLocalRef(Target target, InjectionNodes.InjectionNode injectionNode, int n2, StackExtension stackExtension) {
        String string = LocalRefClassGenerator.getForType(this.g);
        n2 = this.getOrCreateRef(target, injectionNode, n2, string, stackExtension);
        stackExtension.extra(1);
        target.insns.insertBefore(injectionNode.getCurrentTarget(), (AbstractInsnNode)new VarInsnNode(25, n2));
    }

    private int getOrCreateRef(Target target, InjectionNodes.InjectionNode injectionNode, int n2, String string, StackExtension stackExtension) {
        HashMap<Integer, Integer> hashMap = (HashMap<Integer, Integer>)injectionNode.getDecoration("mixinextras_localRefMap");
        if (hashMap == null) {
            hashMap = new HashMap<Integer, Integer>();
            injectionNode.decorate("mixinextras_localRefMap", hashMap);
        }
        if (hashMap.containsKey(n2)) {
            return (Integer)hashMap.get(n2);
        }
        int n3 = target.allocateLocal();
        target.addLocalVariable(n3, "ref".concat(String.valueOf(n3)), "L" + string + ';');
        string = new InsnList();
        LocalRefUtils.generateNew((InsnList)string, this.g);
        string.add((AbstractInsnNode)new VarInsnNode(58, n3));
        target.insertBefore(injectionNode, (InsnList)string);
        LocalSugarApplicator localSugarApplicator = this;
        SugarPostProcessingExtension.enqueuePostProcessing(localSugarApplicator, () -> {
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, n3));
            insnList.add((AbstractInsnNode)new VarInsnNode(this.g.getOpcode(21), n2));
            LocalRefUtils.generateInitialization(insnList, this.g);
            target.insertBefore(injectionNode, insnList);
            insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, n3));
            LocalRefUtils.generateDisposal(insnList, this.g);
            insnList.add((AbstractInsnNode)new VarInsnNode(this.g.getOpcode(54), n2));
            target.insns.insert(injectionNode.getCurrentTarget(), insnList);
        });
        stackExtension.extra(this.g.getSize() + 1);
        hashMap.put(n2, n3);
        return n3;
    }
}

